"""
Workspace Manager - tmux + git worktree + container isolation.

This module implements AGPL-free workspace isolation for agents:
- Git worktrees for repo isolation
- tmux sessions for process isolation
- Docker/Podman containers for container isolation
- CLI-friendly multi-agent management
"""

from .manager import (
    DIYAgentWorkspace,
    WorkspaceInfo,
    setup_multi_agent_workspace,
)
from .isolation import (
    IsolationManager,
    IsolationConfig,
    IsolationType,
    IsolatedEnvironment,
    ResourceLimits,
    CredentialConfig,
    NetworkMode,
)

__all__ = [
    # Workspace manager
    "DIYAgentWorkspace",
    "WorkspaceInfo",
    "setup_multi_agent_workspace",
    # Isolation
    "IsolationManager",
    "IsolationConfig",
    "IsolationType",
    "IsolatedEnvironment",
    "ResourceLimits",
    "CredentialConfig",
    "NetworkMode",
]
