"""
Tracking - Usage and availability tracking for agents.

This module provides:
- CLI agent session tracking
- Usage statistics
- Availability management
- Load balancing helpers
- Native CLI state file reading
- Rate limit monitoring
"""

from .cli_usage import (
    CLIUsageTracker,
    SessionUsage,
    WeeklyUsage,
    CLIAgentLimits,
    AgentAvailability,
    DEFAULT_CLI_LIMITS,
    get_cli_tracker,
    set_cli_tracker,
)
from .state_models import (
    RateLimitState,
    SessionState,
    CLIStateSnapshot,
    AgentHealthStatus,
    WindowType,
    WaitingState,
)
from .cli_state_reader import (
    CLIStateReader,
    ClaudeStateReader,
    CodexStateReader,
    GeminiStateReader,
    get_reader_for_agent,
    get_all_readers,
    register_reader,
)
from .rate_limit_monitor import (
    RateLimitMonitor,
    RateLimitAlert,
    get_rate_limit_monitor,
    set_rate_limit_monitor,
)

__all__ = [
    # CLI Usage Tracking
    "CLIUsageTracker",
    "SessionUsage",
    "WeeklyUsage",
    "CLIAgentLimits",
    "AgentAvailability",
    "DEFAULT_CLI_LIMITS",
    "get_cli_tracker",
    "set_cli_tracker",
    # State Models
    "RateLimitState",
    "SessionState",
    "CLIStateSnapshot",
    "AgentHealthStatus",
    "WindowType",
    "WaitingState",
    # CLI State Readers
    "CLIStateReader",
    "ClaudeStateReader",
    "CodexStateReader",
    "GeminiStateReader",
    "get_reader_for_agent",
    "get_all_readers",
    "register_reader",
    # Rate Limit Monitor
    "RateLimitMonitor",
    "RateLimitAlert",
    "get_rate_limit_monitor",
    "set_rate_limit_monitor",
]
