"""
Swarm Intelligence - Distributed agent coordination and collective decision-making.

Provides:
- Task decomposition and distribution
- Result aggregation across agents
- Swarm coordination strategies
- Collective intelligence patterns
"""

from .coordinator import (
    SwarmCoordinator,
    SwarmConfig,
    SwarmState,
    CoordinationStrategy,
)
from .decomposer import (
    TaskDecomposer,
    SubTask,
    DecompositionStrategy,
)
from .aggregator import (
    ResultAggregator,
    AggregatedResult,
    AggregationStrategy,
)

__all__ = [
    "SwarmCoordinator",
    "SwarmConfig",
    "SwarmState",
    "CoordinationStrategy",
    "TaskDecomposer",
    "SubTask",
    "DecompositionStrategy",
    "ResultAggregator",
    "AggregatedResult",
    "AggregationStrategy",
]
