"""
Subscriptions - Subscription tier tracking and management.

Provides:
- Provider and tier enumeration
- Rate limit configurations per tier
- Subscription management for agents
- Auto-detection of subscription tiers
"""

from .tiers import (
    Provider,
    SubscriptionTier,
    TierLimits,
    SubscriptionConfig,
    TIER_CONFIGURATIONS,
    get_tier_limits,
    get_provider_for_tier,
    get_default_tier_for_provider,
    list_tiers_for_provider,
)
from .manager import (
    AgentSubscription,
    SubscriptionManager,
    get_subscription_manager,
    set_subscription_manager,
)
from .detection import (
    TierDetector,
    detect_tier_from_error,
    get_tier_detector,
)

__all__ = [
    # Tiers
    "Provider",
    "SubscriptionTier",
    "TierLimits",
    "SubscriptionConfig",
    "TIER_CONFIGURATIONS",
    "get_tier_limits",
    "get_provider_for_tier",
    "get_default_tier_for_provider",
    "list_tiers_for_provider",
    # Manager
    "AgentSubscription",
    "SubscriptionManager",
    "get_subscription_manager",
    "set_subscription_manager",
    # Detection
    "TierDetector",
    "detect_tier_from_error",
    "get_tier_detector",
]
