"""
Routing module - Task classification and agent routing.

This module provides:
- TaskType enum for classifying tasks
- Routing rules that map tasks to optimal agents
- TaskRouter for making routing decisions
- Budget management for cost control
"""

from .task_types import (
    TaskType,
    AgentTool,
    AgentCapability,
    RoutingRule,
    ROUTING_TABLE,
    AGENT_PROFILES,
    classify_task,
    get_routing_rule,
    get_preferred_agents,
    get_agent_profile,
)

from .router import (
    TaskRouter,
    RouteDecision,
    BudgetManager,
    create_router,
    route_and_execute,
)

__all__ = [
    # Task types
    "TaskType",
    "AgentTool",
    "AgentCapability",
    "RoutingRule",
    "ROUTING_TABLE",
    "AGENT_PROFILES",
    "classify_task",
    "get_routing_rule",
    "get_preferred_agents",
    "get_agent_profile",
    # Router
    "TaskRouter",
    "RouteDecision",
    "BudgetManager",
    "create_router",
    "route_and_execute",
]
