"""
Projects Module

Provides project management and planning functionality.
"""

from .manager import (
    Project,
    ProjectAgent,
    ProjectManager,
    get_project_manager,
    set_project_manager,
)
from .planner import (
    ProjectPlan,
    ProjectPlanner,
    create_project_plan,
)

__all__ = [
    # Manager
    "Project",
    "ProjectAgent",
    "ProjectManager",
    "get_project_manager",
    "set_project_manager",
    # Planner
    "ProjectPlan",
    "ProjectPlanner",
    "create_project_plan",
]
