"""
Plugin System for Agent Orchestration.

Provides:
- Dynamic adapter registration and discovery
- Plugin loading from configuration
- Capability-based adapter lookup
- Lifecycle management for plugins
"""

from .registry import (
    AdapterRegistry,
    PluginMetadata,
    PluginStatus,
)
from .loader import (
    PluginLoader,
    PluginConfig,
)
from .capabilities import (
    AgentCapability,
    CapabilityRegistry,
)

__all__ = [
    # Registry
    "AdapterRegistry",
    "PluginMetadata",
    "PluginStatus",
    # Loader
    "PluginLoader",
    "PluginConfig",
    # Capabilities
    "AgentCapability",
    "CapabilityRegistry",
]
