"""
Orchestrator - Central coordination for the multi-agent system.

This module provides:
- OrchestrationBrain: The central intelligence
- OrchestratorCommands: Command handler for orchestrator actions
- AgentSpawner: Dynamic agent creation
- CommandResult: Result type for commands
- StatusDashboard: Visual status display
"""

from .brain import OrchestrationBrain
from .commands import OrchestratorCommands, CommandResult
from .spawner import AgentSpawner, SpawnedAgent, AgentState
from .dashboard import StatusDashboard, print_dashboard

__all__ = [
    "OrchestrationBrain",
    "OrchestratorCommands",
    "CommandResult",
    "AgentSpawner",
    "SpawnedAgent",
    "AgentState",
    "StatusDashboard",
    "print_dashboard",
]
