"""
Project Journal Protocol - Context handoff between agents.

This module implements the project journal protocol that ensures context
is properly handed off between agent runs through:
- project_state.json: Machine-readable state
- agent_journal.md: Human-readable log
- StatusPacket: Required output from every run
"""

from .status_packet import StatusPacket, TaskArtifacts
from .project_journal import ProjectJournal

__all__ = ["StatusPacket", "TaskArtifacts", "ProjectJournal"]
