"""
Risk Policy - Re-export from risk module.

This module re-exports risk policy classes from the canonical location
at `agent_orchestrator.risk.policy` for backwards compatibility.

New code should import directly from:
    from agent_orchestrator.risk import RiskPolicy, RiskLevel, RiskClassification
"""

# Re-export everything from the canonical location
from agent_orchestrator.risk.policy import (
    RiskLevel,
    RiskClassification,
    RiskDecision,
    RiskPolicy,
    CRITICAL_COMMAND_PATTERNS,
    CRITICAL_FILE_PATTERNS,
    HIGH_RISK_COMMAND_PATTERNS,
    HIGH_RISK_FILE_PATTERNS,
    MEDIUM_RISK_COMMAND_PATTERNS,
    MEDIUM_RISK_FILE_PATTERNS,
    LOW_RISK_COMMAND_PATTERNS,
    LOW_RISK_FILE_PATTERNS,
    # Helper functions
    get_risk_policy,
    classify_command,
    classify_file,
    is_command_blocked,
    is_file_blocked,
)

__all__ = [
    "RiskLevel",
    "RiskClassification",
    "RiskDecision",
    "RiskPolicy",
    "CRITICAL_COMMAND_PATTERNS",
    "CRITICAL_FILE_PATTERNS",
    "HIGH_RISK_COMMAND_PATTERNS",
    "HIGH_RISK_FILE_PATTERNS",
    "MEDIUM_RISK_COMMAND_PATTERNS",
    "MEDIUM_RISK_FILE_PATTERNS",
    "LOW_RISK_COMMAND_PATTERNS",
    "LOW_RISK_FILE_PATTERNS",
    # Helper functions
    "get_risk_policy",
    "classify_command",
    "classify_file",
    "is_command_blocked",
    "is_file_blocked",
]
