"""
Agent Templates Module

Provides a comprehensive library of agent templates for various domains.
"""

from .base import (
    AgentTemplate,
    AgentCapability,
    CollaborationStyle,
    AgentRole,
    AgentTeamComposition,
)
from .registry import (
    TemplateRegistry,
    TemplateMatch,
    get_registry,
    get_template,
    list_templates,
    select_agents_for_task,
    compose_team_for_task,
)
from .creative import CREATIVE_TEMPLATES
from .technical import TECHNICAL_TEMPLATES
from .research import RESEARCH_TEMPLATES

__all__ = [
    # Base classes
    "AgentTemplate",
    "AgentCapability",
    "CollaborationStyle",
    "AgentRole",
    "AgentTeamComposition",
    # Registry
    "TemplateRegistry",
    "TemplateMatch",
    "get_registry",
    "get_template",
    "list_templates",
    "select_agents_for_task",
    "compose_team_for_task",
    # Template collections
    "CREATIVE_TEMPLATES",
    "TECHNICAL_TEMPLATES",
    "RESEARCH_TEMPLATES",
]
