"""
Adapter Layer - Unified interface for all agent types.

This module provides the adapter abstraction that allows the orchestrator
to work with both CLI-based agents (Claude Code, Gemini CLI, Codex CLI) and
API-based agents (Claude Agent SDK, OpenAI Agents SDK) through a single interface.
"""

from .base import (
    BaseAdapter,
    LLMAdapter,
    CLIAgentAdapter,
    AgentResponse,
    UsageStats,
    RiskLevel,
    AgentStatus,
    PromptBuilder,
)

# Pricing utilities
from .pricing import (
    estimate_cost,
    get_model_pricing,
    get_provider_models,
    get_all_models,
    add_model_pricing,
    ModelPricing,
)

# CLI Adapters
from .claude_code_cli import (
    ClaudeCodeCLIAdapter,
    ClaudeCodeConfig,
    create_claude_code_adapter,
)
from .gemini_cli import (
    GeminiCLIAdapter,
    GeminiCLIConfig,
    create_gemini_adapter,
)
from .codex_cli import (
    CodexCLIAdapter,
    CodexCLIConfig,
    AutonomyMode,
    create_codex_adapter,
)

__all__ = [
    # Base classes
    "BaseAdapter",
    "LLMAdapter",
    "CLIAgentAdapter",
    "AgentResponse",
    "UsageStats",
    "RiskLevel",
    "AgentStatus",
    "PromptBuilder",
    # Pricing
    "estimate_cost",
    "get_model_pricing",
    "get_provider_models",
    "get_all_models",
    "add_model_pricing",
    "ModelPricing",
    # CLI Adapters
    "ClaudeCodeCLIAdapter",
    "ClaudeCodeConfig",
    "create_claude_code_adapter",
    "GeminiCLIAdapter",
    "GeminiCLIConfig",
    "create_gemini_adapter",
    "CodexCLIAdapter",
    "CodexCLIConfig",
    "AutonomyMode",
    "create_codex_adapter",
]
