"""
Agent Orchestrator - Multi-agent orchestration system for AI coding agents.

This package provides a unified interface for orchestrating multiple AI coding agents
across CLI (Claude Code, Gemini CLI, Codex CLI) and API (Claude Agent SDK, OpenAI Agents SDK)
interfaces.

Key components:
- adapters: Unified interface for all agent types
- persistence: SQLite-backed state management
- journal: Project journal protocol for context handoff
- control: Health monitoring and control loop
- risk: Four-tier risk classification and autonomy gate
- interrupt: Human approval interfaces (CLI and async)
- budget: Cost controls for agents and tools
- merge: Protected branch controls
- workspace: tmux + worktree management
- secrets: Secret redaction and protection
- exceptions: Custom exception hierarchy
"""

__version__ = "0.1.0"
__author__ = "Agent Orchestration Team"

# Export commonly used exceptions at package level
from .exceptions import (
    OrchestratorError,
    AgentError,
    AgentNotFoundError,
    AgentUnavailableError,
    AgentAuthenticationError,
    AgentTimeoutError,
    AgentExecutionError,
    TaskError,
    TaskNotFoundError,
    TaskAssignmentError,
    TaskExecutionError,
    RiskError,
    RiskBlockedError,
    ApprovalRequiredError,
    BudgetError,
    BudgetExceededError,
    RateLimitError,
    ConfigurationError,
)

__all__ = [
    "__version__",
    "__author__",
    # Exceptions
    "OrchestratorError",
    "AgentError",
    "AgentNotFoundError",
    "AgentUnavailableError",
    "AgentAuthenticationError",
    "AgentTimeoutError",
    "AgentExecutionError",
    "TaskError",
    "TaskNotFoundError",
    "TaskAssignmentError",
    "TaskExecutionError",
    "RiskError",
    "RiskBlockedError",
    "ApprovalRequiredError",
    "BudgetError",
    "BudgetExceededError",
    "RateLimitError",
    "ConfigurationError",
]
