# New Project

A new project created through the Agent Orchestration system.

## Project Information

- **Project ID**: new-project-001
- **Status**: Active
- **Created**: 2026-01-15
- **Phase**: Initialization

## Structure

```
new_project/
├── project_config.json    # Project configuration
├── README.md              # This file
├── src/                   # Source code directory
├── tests/                 # Test files
└── docs/                  # Documentation
```

## Getting Started

### 1. Define Your Project

Edit `project_config.json` to specify:
- Project name and description
- Domain classification (TECHNICAL, RESEARCH, CREATIVE, OPERATIONS)
- Requirements and features
- Technical stack

### 2. Assign Agents

Use the ProjectManager to assign agents based on your project domain:
- Lead agent for overall coordination
- Specialists for specific tasks
- Reviewers for quality assurance
- Support agents for auxiliary tasks

### 3. Submit Tasks

Submit tasks through the Orchestrator:

```python
from agent_orchestrator import Orchestrator

orchestrator = Orchestrator()
await orchestrator.start()

task = await orchestrator.submit_task(
    description="Your task description here",
    project_id="new-project-001"
)
```

### 4. Track Progress

Monitor progress through:
- Project state updates in `project_config.json`
- Task completion tracking
- Memory system for context retention

## Memory Integration

This project integrates with the two-tier memory architecture:

- **Tier 1 (Authoritative)**: Project configuration and decisions
- **Tier 2 (Working Knowledge)**: Runbooks, patterns, context
- **Tier 3 (Ephemeral)**: Temporary working data

All memory writes go through the Memory Write Gate for validation.

## Constraints

- Agents cannot directly modify Tier 0/1 memory
- All state changes require Memory Write Gate approval
- HIGH-risk patches require explicit human approval
- Maximum 5 items per knowledge query
- No secrets in memory items

## Next Steps

1. Customize `project_config.json` with your project details
2. Create source directories: `src/`, `tests/`, `docs/`
3. Define initial requirements and features
4. Submit your first task through the orchestrator
5. Monitor progress and adjust as needed

## Resources

- [Agent Orchestration Docs](/var/www/html/Agent_Orchestration/docs/)
- [Architecture Decision Records](/var/www/html/Agent_Orchestration/ops/decisions/)
- [Runbooks](/var/www/html/Agent_Orchestration/ops/runbooks/)
- [Examples](/var/www/html/Agent_Orchestration/examples/)
