# CLI Authentication Runbook

## Purpose

Authenticate Claude Code, Gemini CLI, and Codex CLI via interactive/web flows so the orchestrator can prioritize CLI agents over API usage.

## Prerequisites

- CLI tools installed for each provider
- Network access for the interactive/web login flow

## Procedure

### 1. Authenticate Each CLI

For each CLI agent:

1. Launch the CLI to trigger its interactive/web login flow.
2. Complete the browser-based authentication steps.
3. Confirm the CLI session is active by running a simple prompt or status command.

Notes:
- Avoid setting API keys unless a task explicitly requires API access.
- Store no secrets in the repository; use the provider's standard credential store.

### 2. Verify Orchestrator Readiness

Before starting the orchestrator:

- Ensure all three CLI agents can run a basic prompt.
- If any CLI fails to authenticate, re-run its login flow.

### 3. Re-authenticate When Limits Are Hit

If a CLI agent reaches a session or weekly limit:

1. Mark the agent as unavailable in the orchestrator configuration or routing rules.
2. Route tasks to another authenticated CLI agent.
3. Re-authenticate the limited agent when the limit resets.

## Troubleshooting

- If login loops or fails, remove the CLI's cached credentials and re-run the login flow.
- If authentication succeeds but commands fail, verify the CLI version and upgrade if needed.
