# Budget Flow Diagram

This diagram shows the budget enforcement and cost optimization system.

```mermaid
flowchart TD
    subgraph "Budget Check Flow"
        A[Task Request] --> B{Check Agent Budget}
        B -->|Under Limit| C{Check MCP Budget}
        B -->|Over Limit| D[Budget Alert]

        C -->|Under Limit| E{Check Tool Budget}
        C -->|Over Limit| D

        E -->|Under Limit| F[Execute Task]
        E -->|Over Limit| D

        D --> G{Alert Severity}
        G -->|Warning 50%| H[Log Warning]
        G -->|Warning 75%| I[Send Alert]
        G -->|Critical 90%| J[Rate Limit]
        G -->|Exhausted 100%| K[Block Execution]

        H --> L{Continue?}
        I --> L
        J --> L
        L -->|Yes| F
        L -->|No| M[Reject Task]
        K --> M
    end

    subgraph "Usage Recording"
        F --> N[Execute Task]
        N --> O[Record Usage]
        O --> P[Update Daily Totals]
        P --> Q{Check Thresholds}
        Q -->|Threshold Hit| R[Trigger Alert]
        Q -->|Under Threshold| S[Continue]
    end

    subgraph "Cost Optimization"
        T[Usage Records] --> U[Analyze Patterns]
        U --> V{Find Inefficiencies}

        V -->|High Retry Rate| W[Recommend: Fix Failures]
        V -->|Overprovisioned Model| X[Recommend: Use Cheaper Model]
        V -->|Excessive Tokens| Y[Recommend: Optimize Prompts]
        V -->|Peak Hours| Z[Recommend: Shift Load]

        W --> AA[Optimization Report]
        X --> AA
        Y --> AA
        Z --> AA
    end
```

## Budget Hierarchy

```mermaid
graph TB
    subgraph "Global Budget"
        GB[Total Daily Budget: $100]
    end

    subgraph "Agent Budgets"
        AB1[claude-code: $40/day]
        AB2[gemini-cli: $30/day]
        AB3[codex-cli: $30/day]
    end

    subgraph "MCP Server Budgets"
        MB1[filesystem: 1000 calls/day]
        MB2[github: 500 calls/day]
        MB3[database: 200 calls/day]
    end

    subgraph "Tool Budgets"
        TB1[write_file: 100/day]
        TB2[create_pr: 20/day]
        TB3[run_query: 50/day]
    end

    GB --> AB1
    GB --> AB2
    GB --> AB3

    AB1 --> MB1
    AB1 --> MB2
    AB2 --> MB1
    AB3 --> MB3

    MB1 --> TB1
    MB2 --> TB2
    MB3 --> TB3
```

## Alert Thresholds

| Threshold | Action | Severity |
|-----------|--------|----------|
| 50% | Log warning | INFO |
| 75% | Send notification | WARNING |
| 90% | Rate limit requests | ERROR |
| 100% | Block execution | CRITICAL |

## Cost Optimization Analysis

The CostOptimizer analyzes usage patterns to detect:

### 1. High Retry Rates
```
Agent 'claude-code' has 25% retry rate.
Investigate failures to reduce retries.
Potential savings: $12.50/day
```

### 2. Overprovisioned Models
```
Task 'simple_format' used Opus for LOW complexity.
Consider using Haiku instead.
Potential savings: $8.00/task
```

### 3. Excessive Token Usage
```
Task 'code_review' used 50,000 tokens,
significantly above average (15,000).
Consider prompt optimization.
Potential savings: $3.50/task
```

### 4. Peak Hour Usage
```
60% of usage occurs during peak hours (9-11 AM).
Consider shifting batch jobs to off-peak times.
Potential savings: 15% on compute costs
```

## Cost Projections

```mermaid
xychart-beta
    title "30-Day Cost Projection"
    x-axis [Week 1, Week 2, Week 3, Week 4]
    y-axis "Cost ($)" 0 --> 800
    line "Projected" [180, 365, 550, 740]
    line "Budget" [175, 350, 525, 700]
```

Based on current trends:
- **Daily**: $24.67
- **Weekly**: $172.69
- **Monthly**: $740.10
- **Trend**: Increasing (5% week-over-week)
