# Architecture Diagrams

This directory contains Mermaid-based architecture diagrams for the Agent Orchestration system.

## Diagrams

| Diagram | Description |
|---------|-------------|
| [System Overview](./system-overview.md) | High-level architecture showing all components |
| [Task Flow](./task-flow.md) | Sequence diagram of task execution |
| [Risk Gate](./risk-gate.md) | Risk classification and gating logic |
| [Memory Architecture](./memory-architecture.md) | Four-tier memory system |
| [Budget Flow](./budget-flow.md) | Budget enforcement and cost optimization |
| [Agent Coordination](./agent-coordination.md) | Handoffs, voting, swarm patterns |
| [Workflow Engine](./workflow-engine.md) | JSON workflow execution |
| [Session Tracing](./session-tracing.md) | LangSmith-style tracing system |

## Viewing Diagrams

These diagrams use [Mermaid](https://mermaid.js.org/) syntax and render automatically on GitHub.

For local viewing, you can use:
- VS Code with Mermaid extension
- Mermaid Live Editor: https://mermaid.live/
- Any Markdown viewer with Mermaid support

## Quick Reference

### System Layers

```
┌─────────────────────────────────────────────────┐
│ User Interface: CLI │ TUI │ REST API            │
├─────────────────────────────────────────────────┤
│ Orchestration: Brain │ Spawner │ Workflows      │
├─────────────────────────────────────────────────┤
│ Coordination: Loop │ Health │ Handoff │ Swarm   │
├─────────────────────────────────────────────────┤
│ Control: Risk │ Budget │ Tiers │ Interactions   │
├─────────────────────────────────────────────────┤
│ Agents: Claude │ Gemini │ Codex │ SDKs          │
├─────────────────────────────────────────────────┤
│ Memory: Operational │ Knowledge │ Working       │
├─────────────────────────────────────────────────┤
│ Persistence: SQLite │ Traces │ Files            │
└─────────────────────────────────────────────────┘
```

### Risk Levels

| Level | Auto-Behavior | Examples |
|-------|---------------|----------|
| LOW | Auto-approve | Read, list, test |
| MEDIUM | Confirm | Install, commit |
| HIGH | Approve + warn | Auth, migrate |
| CRITICAL | Auto-reject | Force push, destroy |

### Memory Tiers

| Tier | Purpose | Access |
|------|---------|--------|
| 0 | Immutable audit | Append-only |
| 1 | Authoritative | WriteGate |
| 2 | Working knowledge | Librarian |
| 3 | Ephemeral cache | Direct |
