# API Overview

The Agent Orchestrator REST API provides programmatic access to manage AI coding agents, submit tasks, monitor usage, and control the orchestration system.

## Base URL

- **Development**: `http://localhost:8080/api`
- **Production**: `https://api.orchestrator.example.com/api`

## Authentication

All API requests require authentication via the `X-API-Key` header:

```bash
curl -H "X-API-Key: your-api-key" https://api.orchestrator.example.com/api/health
```

## Rate Limiting

- **Limit**: 100 requests per minute per API key
- **Status Code**: 429 Too Many Requests when exceeded
- **Headers**:
  - `X-RateLimit-Limit`: Maximum requests per window
  - `X-RateLimit-Remaining`: Requests remaining
  - `X-RateLimit-Reset`: Unix timestamp when window resets

## Response Format

All responses are JSON with consistent structure:

### Success Response

```json
{
  "data": { ... },
  "meta": {
    "request_id": "req_abc123",
    "timestamp": "2026-01-15T10:30:00Z"
  }
}
```

### Error Response

```json
{
  "error": {
    "code": "TASK_NOT_FOUND",
    "message": "Task with ID 'task-123' not found",
    "details": {
      "task_id": "task-123"
    }
  }
}
```

## Error Codes

| Code | HTTP Status | Description |
|------|-------------|-------------|
| `INVALID_REQUEST` | 400 | Request body or parameters invalid |
| `UNAUTHORIZED` | 401 | Missing or invalid API key |
| `FORBIDDEN` | 403 | API key lacks required permissions |
| `NOT_FOUND` | 404 | Resource not found |
| `CONFLICT` | 409 | Operation conflicts with current state |
| `RATE_LIMITED` | 429 | Too many requests |
| `INTERNAL_ERROR` | 500 | Server error |

## Endpoints Overview

### Health & Status

| Method | Endpoint | Description |
|--------|----------|-------------|
| GET | `/health` | System health check |
| GET | `/stats` | Comprehensive statistics |

### Agents

| Method | Endpoint | Description |
|--------|----------|-------------|
| GET | `/agents` | List all agents |
| GET | `/agents/{id}` | Get agent details |
| PATCH | `/agents/{id}/status` | Pause/resume agent |

### Tasks

| Method | Endpoint | Description |
|--------|----------|-------------|
| GET | `/tasks` | List tasks |
| POST | `/tasks` | Create new task |
| GET | `/tasks/{id}` | Get task details |
| DELETE | `/tasks/{id}` | Cancel task |

### Usage & Costs

| Method | Endpoint | Description |
|--------|----------|-------------|
| GET | `/usage/summary` | Usage summary |
| GET | `/usage/{agent_id}` | Agent usage |
| GET | `/rate-limits` | Rate limit status |
| GET | `/rate-limits/alerts` | Rate limit alerts |
| GET | `/costs` | Cost summary |
| GET | `/costs/projections` | Cost projections |
| GET | `/costs/recommendations` | Optimization tips |

### Subscriptions

| Method | Endpoint | Description |
|--------|----------|-------------|
| GET | `/subscriptions` | List all subscriptions |
| GET | `/subscriptions/{agent_id}` | Agent subscription |

### Interactions

| Method | Endpoint | Description |
|--------|----------|-------------|
| GET | `/interactions` | Pending interactions |
| POST | `/interactions/{id}` | Respond to interaction |
| GET | `/interactions/history` | Interaction history |

## Quick Start

### 1. Check System Health

```bash
curl -H "X-API-Key: your-key" \
  http://localhost:8080/api/health
```

Response:
```json
{
  "status": "healthy",
  "agents_active": 3,
  "tasks_pending": 5,
  "uptime_seconds": 3600
}
```

### 2. List Available Agents

```bash
curl -H "X-API-Key: your-key" \
  http://localhost:8080/api/agents
```

Response:
```json
[
  {
    "agent_id": "claude-code",
    "agent_type": "cli",
    "status": "available",
    "subscription_tier": "max",
    "current_task": null
  },
  {
    "agent_id": "gemini-cli",
    "agent_type": "cli",
    "status": "busy",
    "subscription_tier": "pro",
    "current_task": "task-456"
  }
]
```

### 3. Submit a Task

```bash
curl -X POST \
  -H "X-API-Key: your-key" \
  -H "Content-Type: application/json" \
  -d '{
    "description": "Implement a fibonacci function in Python",
    "priority": 7
  }' \
  http://localhost:8080/api/tasks
```

Response:
```json
{
  "task_id": "task-789",
  "description": "Implement a fibonacci function in Python",
  "status": "pending",
  "agent_id": null,
  "priority": 7,
  "created_at": "2026-01-15T10:30:00Z"
}
```

### 4. Check Task Status

```bash
curl -H "X-API-Key: your-key" \
  http://localhost:8080/api/tasks/task-789
```

Response:
```json
{
  "task_id": "task-789",
  "description": "Implement a fibonacci function in Python",
  "status": "completed",
  "agent_id": "claude-code",
  "priority": 7,
  "created_at": "2026-01-15T10:30:00Z",
  "started_at": "2026-01-15T10:30:05Z",
  "completed_at": "2026-01-15T10:31:30Z",
  "output": "Created fibonacci.py with iterative implementation...",
  "risk_level": "LOW",
  "tokens_used": 1250,
  "cost_usd": 0.025
}
```

### 5. Get Cost Summary

```bash
curl -H "X-API-Key: your-key" \
  "http://localhost:8080/api/costs?period=today"
```

Response:
```json
{
  "period": "today",
  "total_cost_usd": 12.50,
  "budget_usd": 50.00,
  "percentage_used": 25.0,
  "by_agent": {
    "claude-code": 8.50,
    "gemini-cli": 3.00,
    "codex-cli": 1.00
  },
  "by_model": {
    "opus": 6.00,
    "sonnet": 4.50,
    "gemini-pro": 2.00
  }
}
```

## Pagination

List endpoints support pagination via `limit` and `offset` parameters:

```bash
curl -H "X-API-Key: your-key" \
  "http://localhost:8080/api/tasks?limit=10&offset=20"
```

Response includes pagination metadata:
```json
{
  "tasks": [...],
  "total": 150,
  "limit": 10,
  "offset": 20
}
```

## Filtering

Many endpoints support filtering:

```bash
# Get only failed tasks
curl "http://localhost:8080/api/tasks?status=failed"

# Get tasks for specific agent
curl "http://localhost:8080/api/tasks?agent_id=claude-code"

# Get usage for this week
curl "http://localhost:8080/api/usage/summary?period=week"
```

## Webhooks (Coming Soon)

Register webhooks to receive real-time notifications:

- Task completed
- Task failed
- Agent status changed
- Budget alert triggered
- Interaction pending

## SDK Support

Official SDKs are available for:
- Python: `pip install agent-orchestrator-client`
- JavaScript: `npm install @agent-orchestrator/client`

See [examples/](./examples/) for usage examples.
