# Deployment & Sync Scripts

Helper scripts for the AEI Scheduler development workflow.

## Scripts

| Script | Purpose |
|--------|---------|
| `ssh_connect.sh` | Convert PPK key and open SSH session to remote server |
| `deploy_local.sh` | Deploy file(s) from working directory to local test site |
| `deploy_remote.sh` | Deploy file(s) to remote production server |
| `verify_deployment.sh` | Post-deployment verification (local or remote) |
| `sync_from_remote.sh` | Pull latest code from remote to local dev |

## Quick Usage

### Connect to remote server
```bash
./scripts/ssh_connect.sh                    # Interactive session
./scripts/ssh_connect.sh "ls /var/www"      # Run single command
```

### Deploy a file locally for testing
```bash
./scripts/deploy_local.sh system/application/controllers/acschedule.php
```

### Deploy a file to production
```bash
./scripts/deploy_remote.sh system/application/controllers/acschedule.php
```

### Verify a deployment
```bash
./scripts/verify_deployment.sh local system/application/controllers/acschedule.php
./scripts/verify_deployment.sh remote system/application/controllers/acschedule.php
```

### Sync everything from remote
```bash
./scripts/sync_from_remote.sh --dry-run     # Preview changes
./scripts/sync_from_remote.sh               # Execute sync
./scripts/sync_from_remote.sh --skip-db     # Skip database sync
```

## Notes

- All scripts protect `database.php` and `config.php` from being overwritten
- `deploy_remote.sh` creates backups before deploying and restores ec2-user ownership
- Scripts assume the PPK key is at `CONNECTORS/SSH/schedular_server_private_key.ppk`
- The converted OpenSSH key is cached at `/tmp/aei_key`
