import 'package:flutter/material.dart';
import 'package:http/http.dart' as http;
import 'dart:convert';
import 'package:shared_preferences/shared_preferences.dart';
import 'package:provider/provider.dart';
import '../token_provider.dart';
// Import the JobDetailsPage
import 'package:intl/intl.dart'; // For formatting dates
import 'job_details_full_view.dart';

class MyJobPage extends StatefulWidget {
  const MyJobPage({super.key});

  @override
  _MyJobPageState createState() => _MyJobPageState();
}

class _MyJobPageState extends State<MyJobPage> {
  List<dynamic> myJobs = [];
  bool isLoading = true;

  @override
  void initState() {
    super.initState();
    fetchMyJobs();
  }

  Future<void> fetchMyJobs() async {
    final token = Provider.of<TokenProvider>(context, listen: false).token;
    SharedPreferences prefs = await SharedPreferences.getInstance();
    String? userId = prefs.getString('user_id');
    try {
      final response = await http.get(
        Uri.parse(
            'https://aeihawaii.com/photoappsch/loginapinew/getjmyjoblisting/$userId'), // Replace with your API URL
        headers: {
          'Content-Type': 'application/json',
          'authorization': token,
        },
      );

      if (response.statusCode == 200) {
        setState(() {
          myJobs = jsonDecode(response.body);
          isLoading = false;
        });
      } else {
        throw Exception('Failed to load my jobs');
      }
    } catch (e) {
      setState(() {
        isLoading = false;
      });
      ScaffoldMessenger.of(context).showSnackBar(
        SnackBar(content: Text('Error: Wrong Job id')),
      );
    }
  }

  @override
  Widget build(BuildContext context) {
    if (isLoading) {
      return Center(child: CircularProgressIndicator());
    }

    if (myJobs.isEmpty) {
      return Center(
        child: Text('No jobs found', style: TextStyle(fontSize: 18)),
      );
    }

    return ListView.builder(
      itemCount: myJobs.length,
      itemBuilder: (context, index) {
        final job = myJobs[index];

        // Format the job date
        String jobDate = '';
        if (job['jobdate'] != null) {
          try {
            print(
                'Job date raw value: ${job['jobdate']} (${job['jobdate']?.runtimeType})');
            final timestamp = int.tryParse(job['jobdate'].toString()) ?? 0;
            final date = DateTime.fromMillisecondsSinceEpoch(
              timestamp < 10000000000 ? timestamp * 1000 : timestamp,
            );
            jobDate = DateFormat('yyyy-MM-dd').format(date);
          } catch (e) {
            print('Date parsing error ');
            jobDate = 'Invalid Date';
          }
        } else {
          jobDate = 'No Date';
        }

        return Card(
          margin: EdgeInsets.symmetric(vertical: 8, horizontal: 16),
          child: ListTile(
            title: Text(job['custname'] ?? 'No Title'),
            subtitle: Column(
              crossAxisAlignment: CrossAxisAlignment.start,
              children: [
                Text(job['address'] ?? 'No Address'),
                Text('Date: $jobDate'), // Display formatted date
                Text('Job ID: ${job['id']}'),
                Text('Job Type: ${job['type']}'),
              ],
            ),
            trailing: Icon(Icons.arrow_forward),
            onTap: () {
              // Retrieve token from Provider
              final cid = int.tryParse(job['customerId'] ?? '');
              final jid = int.tryParse(job['id'] ?? '');
              //final token =          Provider.of<TokenProvider>(context, listen: false).token;
              if (cid != null && jid != null) {
                // Navigate to the JobDetailsPage
                Navigator.push(
                  context,
                  MaterialPageRoute(
                    builder: (context) => JobDetailsFullView(jobId: jid),
                  ),
                );
              }
            },
          ),
        );
      },
    );
  }
}
