// lib/pages/job_all_tabs_full_view.dart
import 'package:flutter/material.dart';

// Reuse your existing pages:
import 'job_photos_full_view.dart';
import 'job_docs_full_view.dart';
import 'job_notes_full_view.dart';
import 'job_details_full_view.dart';

class JobAllTabsFullView extends StatefulWidget {
  final int jobId;
  final int? customerId; // optional, for Notes tab if you like
  final String? customerName; // optional header label
  final String? tokenOverride; // optional, if you want to pass a token

  const JobAllTabsFullView({
    super.key,
    required this.jobId,
    this.customerId,
    this.customerName,
    this.tokenOverride,
  });

  @override
  State<JobAllTabsFullView> createState() => _JobAllTabsFullViewState();
}

class _JobAllTabsFullViewState extends State<JobAllTabsFullView>
    with SingleTickerProviderStateMixin {
  late final TabController _tabController;

  @override
  void initState() {
    super.initState();
    // 4 tabs: Photos, Docs, Notes, Details
    _tabController = TabController(length: 4, vsync: this);
  }

  @override
  void dispose() {
    _tabController.dispose();
    super.dispose();
  }

  @override
  Widget build(BuildContext context) {
    final name = widget.customerName ?? 'Job';

    return Scaffold(
      appBar: AppBar(
        backgroundColor: Colors.green,
        title: Text('$name • #${widget.jobId}'),
        bottom: TabBar(
          controller: _tabController,
          isScrollable: true,
          labelColor: Colors.white,
          unselectedLabelColor: Colors.white70,
          tabs: const [
            Tab(text: 'Photos', icon: Icon(Icons.photo_library_outlined)),
            Tab(text: 'Docs', icon: Icon(Icons.description_outlined)),
            Tab(text: 'Notes', icon: Icon(Icons.sticky_note_2_outlined)),
            Tab(text: 'Details', icon: Icon(Icons.info_outline)),
          ],
        ),
      ),
      body: TabBarView(
        controller: _tabController,
        children: [
          // 1) PHOTOS — reuse your full-feature photos page
          JobPhotosFullView(
            jobId: widget.jobId,
            customerName: widget.customerName ?? 'Photos',
            tokenOverride: widget.tokenOverride,
          ),

          // 2) DOCS
          JobDocsFullView(jobId: widget.jobId),

          // 3) NOTES — needs both customerId and jobId in your implementation
          JobNotesFullView(
            customerId: (widget.customerId ?? 0),
            jobId: widget.jobId,
          ),

          // 4) DETAILS — your full details page as a tab
          JobDetailsFullView(jobId: widget.jobId),
        ],
      ),
    );
  }
}
