import 'package:flutter/material.dart';

class EditCustomerPage extends StatefulWidget {
  final int? customerId;
  const EditCustomerPage({super.key, this.customerId});

  @override
  _EditCustomerPageState createState() => _EditCustomerPageState();
}

class _EditCustomerPageState extends State<EditCustomerPage> {
  final TextEditingController firstNameController = TextEditingController();
  final TextEditingController lastNameController = TextEditingController();
  final TextEditingController emailController = TextEditingController();
  final TextEditingController phoneController = TextEditingController();
  final TextEditingController addressController = TextEditingController();

  bool flagged = false;
  bool addAnotherName = false;
  String selectedPhoneType = 'Mobile';

  @override
  Widget build(BuildContext context) {
    return Scaffold(
      appBar: AppBar(
        backgroundColor: Colors.green,
        title: const Text('Edit Customer'),
      ),
      body: SingleChildScrollView(
        padding: const EdgeInsets.all(16),
        child: Column(
          crossAxisAlignment: CrossAxisAlignment.start,
          children: [
            // ✅ Checkbox: Flagged
            Row(
              children: [
                Checkbox(
                  value: flagged,
                  onChanged: (val) {
                    setState(() => flagged = val!);
                  },
                ),
                const Text('Flagged, Do not service',
                    style: TextStyle(fontWeight: FontWeight.bold)),
              ],
            ),

            _buildTextField('First Name', firstNameController),
            _buildTextField('Last Name', lastNameController),

            // ✅ Checkbox: Add Another Name
            Row(
              children: [
                Checkbox(
                  value: addAnotherName,
                  onChanged: (val) {
                    setState(() => addAnotherName = val!);
                  },
                ),
                const Text('Add Another Name',
                    style: TextStyle(fontWeight: FontWeight.bold)),
              ],
            ),

            _buildTextField('Email', emailController),

            const SizedBox(height: 12),
            const Text('Select Phone',
                style: TextStyle(fontWeight: FontWeight.bold)),
            DropdownButton<String>(
              value: selectedPhoneType,
              isExpanded: true,
              items: ['Mobile', 'Home', 'Work']
                  .map((type) => DropdownMenuItem<String>(
                        value: type,
                        child: Text(type),
                      ))
                  .toList(),
              onChanged: (value) {
                setState(() => selectedPhoneType = value!);
              },
            ),
            const SizedBox(height: 12),

            _buildTextField('Phone', phoneController),
            _buildTextField('Address', addressController),

            const SizedBox(height: 24),
            ElevatedButton(
              style: ElevatedButton.styleFrom(backgroundColor: Colors.green),
              onPressed: () {
                // Save changes
                Navigator.pop(context, 'updated'); // Return to previous screen
              },
              child: const Text('Save'),
            ),
          ],
        ),
      ),
    );
  }

  Widget _buildTextField(String label, TextEditingController controller) {
    return Padding(
      padding: const EdgeInsets.symmetric(vertical: 8),
      child: TextField(
        controller: controller,
        decoration: InputDecoration(
          labelText: label,
          border: const OutlineInputBorder(),
        ),
      ),
    );
  }
}
