import 'package:flutter/material.dart';
import 'package:provider/provider.dart';
import 'token_provider.dart';
import 'login_page.dart';
import 'services/upload_queue_service.dart';

void main() async {
  WidgetsFlutterBinding.ensureInitialized();
  await UploadQueueService.instance.init();

  runApp(
    ChangeNotifierProvider(
      create: (context) => TokenProvider(),
      child: MyApp(),
    ),
  );
}

class MyApp extends StatefulWidget {
  const MyApp({super.key});

  @override
  State<MyApp> createState() => _MyAppState();
}

class _MyAppState extends State<MyApp> {
  @override
  void initState() {
    super.initState();

    // Wire up token getter so the queue service can read the current token
    UploadQueueService.instance.tokenGetter = () {
      try {
        return context.read<TokenProvider>().token;
      } catch (_) {
        return '';
      }
    };

    // Listen for auth-required events from the queue (401 responses)
    UploadQueueService.instance.onAuthRequired.stream.listen((_) {
      // Show a snackbar prompting re-login. The queue is paused and will
      // resume automatically on next successful token set.
      final messenger = ScaffoldMessenger.maybeOf(context);
      messenger?.showSnackBar(
        const SnackBar(
          content: Text('Session expired. Please log in again to resume uploads.'),
          duration: Duration(seconds: 5),
        ),
      );
    });
  }

  @override
  Widget build(BuildContext context) {
    return MaterialApp(
      title: 'Job App',
      theme: ThemeData(
        primarySwatch: Colors.blue,
      ),
      home: LoginPage(),
    );
  }
}
