# FIX-002: Photo Loading — Thumbnails for Grid + Error Handling

## Problem

Photos fail to load on the mobile app for certain customers (e.g., customer 3240 — "Lisa & David Trowbridge"). The grid shows perpetual loading spinners with no error feedback. Investigation revealed two issues:

1. **Grid downloads full 1024px WebP images** for every thumbnail tile. The API returns `thumb_link` (200x200 WebP) but the Flutter code ignored it, only using `link` (1024px standard).

2. **FutureBuilder silently swallows download errors** — when `getSingleFile()` throws, the builder only checks `!snap.hasData`, causing perpetual loading spinners instead of showing an error.

## Root Cause

The API (getimagelisting1.php) returns three URL tiers per photo:
- `thumb_link` — 200x200 Q70 WebP (2-5KB each)
- `link` — 1024px Q75 WebP (25-100KB each)
- `full_link` — 2048px Q82 WebP (50-200KB each)

The Flutter code only read `link` and `fullpath` (which doesn't exist in the response). Both the grid and full-screen gallery used the same 1024px URL.

## Fix

### Files Modified

1. **`lib/models/photo_item.dart`** — Added `thumbUrl` and `fullUrl` fields
2. **`lib/pages/job_photos_full_view.dart`** —
   - Parse `thumb_link` and `full_link` from API response
   - Grid uses `_getCachedThumb()` with `thumb_link` URLs (200x200, ~3KB)
   - Full-screen uses `_getCachedFile()` with `full_link` URLs (2048px hi-res)
   - Added error handling: broken image icon + "Tap to retry" for failed downloads
   - Separate `_thumbFutures` cache to avoid conflicts with full-size cache
3. **`lib/pages/full_screen_gallery.dart`** — Added error state display for failed image loads

### Benefits
- Grid loads ~20x faster (200x200 thumbnails vs 1024px images)
- Errors are visible instead of perpetual spinners
- Tap-to-retry on failed thumbnails
- Full-screen gallery uses hi-res (2048px) for better quality
- Backward compatible: falls back to `link` if `thumb_link`/`full_link` are empty

## Testing

1. Open any customer's photo tab — grid should load noticeably faster
2. Open customer 3240 (Lisa & David Trowbridge) — verify photos now load
3. Open full-screen gallery — verify hi-res images load
4. Test error state: disconnect network, open photos — should show broken image icons
5. Reconnect and tap broken image — should retry and load

## Date
2026-02-20
