# FIX-001: Notes Tab Keyboard Covers Save/Delete Buttons

## Problem
When a user opens the Notes tab and taps into the note text field, the mobile keyboard slides up and covers the "Save" and "Delete" buttons. The user cannot submit or delete the note without first dismissing the keyboard.

## Root Cause
The `EditJobNotePage` form used a `Column` layout inside `Padding` with no scrolling. When the keyboard opens, the Scaffold resizes but the Column content overflows — the buttons at the bottom are pushed below the visible area with no way to reach them.

## Fix
- Wrapped the form `Column` in a `SingleChildScrollView` so the entire form is scrollable when the keyboard is open
- Added `resizeToAvoidBottomInset: true` on the Scaffold (explicit, ensures resize behavior)
- Added `keyboardDismissBehavior: ScrollViewKeyboardDismissBehavior.onDrag` so users can dismiss the keyboard by dragging
- Added bottom padding (24px) below the buttons so they aren't flush against the keyboard edge

## File Changed
- `lib/pages/edit_job_note_page.dart`

## Testing
1. Open any job's Notes tab
2. Tap an existing note or create a new one
3. Tap into the note text field — keyboard opens
4. Scroll down — Save and Delete buttons are now visible and tappable
5. Drag the form area down — keyboard dismisses
