# AEI Cron Job Inventory

Complete inventory of all scheduled tasks on both servers, with known anomalies.

**Last updated:** 2026-02-17

---

## Remote Server (18.225.0.90 — AWS)

### root crontab

| Schedule | Command | Purpose | Verify |
|----------|---------|---------|--------|
| `*/5 * * * *` | `wget -q -O /dev/null http://aeihawaii.com/scheduler/cron` | Scheduler background tasks (email checks, job processing) | `sudo grep 'scheduler/cron' /var/log/cron \| tail -3` |
| `*/5 * * * *` | `wget -q -O /dev/null http://aeihawaii.com/scheduler/ticketcron/index` | osTicket email polling | `sudo grep 'ticketcron' /var/log/cron \| tail -3` |
| `15 23 * * *` | `wget -q -O /dev/null http://aeihawaii.com/scheduler/permitapi/admincron` | Admin maintenance cron | `sudo grep 'admincron' /var/log/cron \| tail -1` |
| `50 3 * * *` | `/sbin/service mysqld restart` | Daily MySQL restart (3:50 AM) | `sudo grep 'mysqld' /var/log/cron \| tail -2` |
| `50 6 * * *` | `/sbin/service mysqld restart` | Daily MySQL restart (6:50 AM) | Same as above |
| `*/15 * * * *` | `/usr/local/bin/python3.6 .../process_retry_queue.py` | Photo sync retry queue processor | `sudo grep 'process_retry' /var/log/cron \| tail -3` |

### Julian crontab

| Schedule | Command | Purpose | Verify |
|----------|---------|---------|--------|
| `0 2 * * *` | `.../dev/scheduler/scripts/cleanup_pdftemp.sh` | PDF temp file cleanup | `ls -la /var/www/vhosts/aeihawaii.com/httpdocs/dev/scheduler/scripts/cleanup_pdftemp.sh` |

### ec2-user crontab

Empty — no entries.

### /etc/cron.d/

| File | Contents |
|------|----------|
| `0hourly` | Standard anacron trigger |
| `raid-check` | RAID health check |
| `update-motd` | MOTD update |

### /etc/cron.daily/

| Script | Purpose |
|--------|---------|
| `logrotate` | Log rotation |
| `man-db.cron` | Man page index update |
| `tmpwatch` | Temp file cleanup |

---

## Local Server (72.235.242.139 — WSL2)

### root crontab

| Schedule | Command | Purpose | Verify |
|----------|---------|---------|--------|
| `30 5 * * 1-5` | `python3 /var/opt/map_dropbox/daily_database_sync.py` | Sync customer data from remote DB | `tail -5 /var/opt/map_dropbox/logs/cron.log` |
| `0 2 * * *` | `php .../cleanup_pdftemp_standalone.php` | PDF temp cleanup (local) | `tail -5 /var/log/pdftemp_cleanup.log` |
| `0 * * * *` | `php .../sync_user_status_cron.php` | Sync user status between schedular/tracksmart DBs | `tail -5 /var/log/user_status_sync.log` |
| `*/30 7-19 * * 1-5` | `.../dropbox/cron_index_update.php` | Customer search index — incremental | `tail -5 /var/www/html/dropbox/logs/cron_output.log` |
| `0 3 * * 0` | `.../dropbox/cron_index_update.php` | Customer search index — full rebuild (Sunday) | Same log |
| `0 4 * * 0` | `find .../dropbox/logs -mtime +30 -delete` | Clean old search index logs | Check for old files |
| `59 23 * * *` | `php /path/to/your/script/reset_counters.php` | **PLACEHOLDER** — path not set | N/A — does nothing |
| `* * * * *` | `php worker.php >> storage/worker.log` | Unknown worker (relative path) | Check which dir this runs from |
| `* * * * *` | `.../security/process_queue.sh` | BadActor IP blocking queue | `tail -5 /var/log/badactor_queue.log` |
| `0 4 * * *` | `.../security/update_cloudflare_ips.sh` | Cloudflare IP range update | `tail -5 /var/log/badactor_cf_update.log` |
| `0 5 * * *` | `.../security/update_tor_exits.sh` | TOR exit node blocklist update | `tail -5 /var/log/badactor_tor_update.log` |
| `0 3 * * *` | `python3 /var/opt/microsoft_safe_list/update_ip_list.py` | Microsoft safe sender IP list | `tail -5 /var/log/microsoft_safe_list_cron.log` |
| `0 0 * * *` | `php /var/www/html/jobs/cleanup_tokens.php` | Session/auth token cleanup | `tail -5 /var/log/token_cleanup.log` |

### www-data crontab

| Schedule | Command | Purpose | Verify |
|----------|---------|---------|--------|
| `*/5 * * * *` | `php -f /var/www/html/nextcloud/cron.php` | Nextcloud background tasks | **DEAD** — nextcloud not installed |

### /etc/cron.d/

| File | Schedule | Command | Purpose |
|------|----------|---------|---------|
| `aei-database-backup` | `0 2 * * *` | `/usr/local/bin/aei_database_backup.sh` | Daily DB backup |
| `aei-website-backup` | `0 3 * * 1-5` | `/usr/local/bin/aei_website_backup.sh` | Weekday website backup |
| `badactor-queue` | `* * * * *` | `.../security/process_queue.sh` | **DUPLICATE** of root crontab entry |
| `certbot` | `0 */12 * * *` | `certbot -q renew` | SSL renewal (skipped if systemd active) |
| `fusion-sync` | `30 3 / 0 4 * * *` | `sf_sync.py` / `sf_photo_sync.py` | Salesforce data + photo sync |
| `geoipupdate` | `47 6 * * 3` + `0 0 * * 0` | `geoipupdate` | GeoIP database update |
| `php` | `09,39 * * * *` | `sessionclean` | PHP session cleanup |
| `server-access-schedule` | Disabled | `server-access-open/close.sh` | Time-based access control |
| `e2scrub_all` | Standard | ext4 scrub | Filesystem check |
| `sysstat` | Standard | System stats | Performance monitoring |

### systemd timers (active)

| Timer | Schedule | Purpose |
|-------|----------|---------|
| `phpsessionclean.timer` | Every 30 min | PHP session cleanup |
| `badactor-sync.timer` | ~Hourly | BadActor IP sync |
| `certbot.timer` | 2x daily | SSL cert renewal |
| `snap.certbot.renew.timer` | 2x daily | SSL cert renewal (snap) |
| `geoipupdate.timer` | Weekly (Tue) | GeoIP database update |
| `blocklist-firewall-update.timer` | Daily | Firewall blocklist update |
| `blocklist-firewall.timer` | Daily | Firewall blocklist apply |
| `logrotate.timer` | Daily | Log rotation |
| `apt-daily.timer` | Daily | APT package list update |
| `apt-daily-upgrade.timer` | Daily | APT upgrades |
| `man-db.timer` | Daily | Man page index |
| `systemd-tmpfiles-clean.timer` | Daily | Temp file cleanup |
| `e2scrub_all.timer` | Weekly | Filesystem scrub |
| `dpkg-db-backup.timer` | Daily | dpkg database backup |
| `motd-news.timer` | Daily | MOTD news update |

---

## Known Anomalies

| # | Server | Issue | Severity | Details |
|---|--------|-------|----------|---------|
| 1 | Remote | **Double daily MySQL restart** (03:50 + 06:50) | MEDIUM | Two separate restart entries in root crontab. Likely historical — one should be removed. Each restart causes ~5s downtime. |
| 2 | Remote | **ticketcron hits broken osTicket DB** | HIGH | osTicket's `support1@localhost` MySQL user has access denied. Every 5-min run generates a PHP fatal error that gets emailed. Emails suppressed by `-q -O /dev/null` but errors still logged. |
| 3 | Remote | **admincron endpoint is HTML stub** | LOW | `permitapi/admincron` doesn't map to a real controller action. Returns HTML page, not an error — wget silently discards. Wastes one HTTP request daily. |
| 4 | Local | **Placeholder path** `/path/to/your/script/reset_counters.php` | LOW | Template path never updated. Runs daily at 23:59 but does nothing (file doesn't exist). Generates error in syslog. |
| 5 | Local | **worker.php with relative path** | LOW | `php worker.php >> storage/worker.log` — no absolute path, no working directory. Behavior depends on cron's CWD (usually `/root`). Likely does nothing. |
| 6 | Local | **nextcloud/cron.php doesn't exist** | LOW | www-data crontab runs Nextcloud cron every 5 min but Nextcloud isn't installed. Generates error every 5 min in mail/syslog. |
| 7 | Local | **process_queue.sh duplicated** | LOW | Runs from both root crontab and `/etc/cron.d/badactor-queue`. Both execute every minute — double execution, double logging. One should be removed. |
| 8 | Local | **3x certbot scheduling** | LOW | SSL renewal configured in: `/etc/cron.d/certbot` (2x daily), `certbot.timer` (systemd, 2x daily), `snap.certbot.renew.timer` (snap, 2x daily). The cron.d entry self-disables when systemd is active, but the snap timer is redundant. |
| 9 | Local | **2x geoip update** | LOW | GeoIP update runs from both `/etc/cron.d/geoipupdate` (Wed 6:47 + Sun midnight) and `geoipupdate.timer` (weekly Tue). Harmless but redundant. |
| 10 | Local | **2x PHP session cleanup** | LOW | PHP sessions cleaned by both `/etc/cron.d/php` (every 30 min) and `phpsessionclean.timer` (every 30 min). The cron.d entry self-disables when systemd is active. |
| 11 | Local | **server-access-schedule disabled** | MEDIUM | Time-based access control (open 5 AM, close 10 PM) disabled since 2026-02-05. Server is now accessible 24/7. Intentional or forgotten? |
| 12 | Remote | **Stuck queue items** | MEDIUM | Failed queue items may accumulate in `queue/failed/` if local server is unreachable. Check periodically: `ls -la .../photoapi/queue/failed/` |

---

## Recommendations

### Quick Wins (Low Risk)

1. **Remove anomaly #4** — Delete the placeholder line from root crontab:
   ```bash
   # Remove: 59 23 * * * /usr/bin/php /path/to/your/script/reset_counters.php
   ```

2. **Remove anomaly #5** — Delete or fix the worker.php line:
   ```bash
   # Remove: * * * * * php worker.php >> storage/worker.log 2>&1
   ```

3. **Remove anomaly #6** — Delete Nextcloud cron from www-data crontab:
   ```bash
   sudo crontab -u www-data -e  # Remove the nextcloud line
   ```

4. **Remove anomaly #7** — Remove duplicate process_queue.sh from root crontab (keep cron.d version):
   ```bash
   # Remove from root crontab: * * * * * /var/www/html/security/process_queue.sh ...
   ```

### Investigate (Medium Risk)

5. **Anomaly #1** — Confirm whether both MySQL restarts are needed. If not, remove the 06:50 entry.

6. **Anomaly #2** — Either fix osTicket's MySQL user or disable the ticketcron entry:
   ```bash
   # To disable: comment out in root crontab
   # */5 * * * * wget -q -O /dev/null http://aeihawaii.com/scheduler/ticketcron/index
   ```

7. **Anomaly #11** — Decide whether server-access-schedule should be re-enabled.
