# AEI Credentials Audit

Every credential in the system: what it's for, where it lives, expiry risk, and what breaks if it stops working.

**Last updated:** 2026-02-23

---

## Risk Summary

| Risk | Credential | Impact If Lost | Action Needed |
|------|-----------|----------------|---------------|
| **HIGH** | Gmail IMAP (createleadmail) | Lead emails stop importing | Google may block basic password auth |
| **HIGH** | Gmail IMAP (osticket support) | Ticket emails stop importing | Google may block basic password auth |
| **HIGH** | Mailtrap SMTP | All scheduler emails stop | Account lapse = silent failure |
| **HIGH** | AWS S3 key | S3 image operations fail | No rotation policy; key never rotated |
| **MEDIUM** | MySQL (schedular user) | Photo API breaks | Password doesn't expire but is weak |
| **MEDIUM** | MySQL (AEI_User) | Direct DB access breaks | Same password concern |
| **MEDIUM** | Google Maps API key | Maps/geocoding break | Billing limit or key restriction |
| **MEDIUM** | Photo API auth token | Mobile uploads break | Static token, no expiry |
| **LOW** | NREL PVWatts API key | Solar estimates fail | API v5 may be deprecated |
| **LOW** | SSH key (aei_remote.pem) | Admin access to remote | Key doesn't expire |
| **LOW** | Mailjet SMTP (legacy) | Nothing — already replaced | Can be removed from code |

---

## 1. Database Credentials

### MySQL — `schedular` user

| Field | Value |
|-------|-------|
| **Used by** | Photo API (upload.php, delete.php, getimagelisting.php, process_retry_queue.py) |
| **Stored in** | Hardcoded in each PHP file on remote server |
| **Documented in** | `AEI_PHOTO_API_PROJECT/DOCS/CREDENTIALS.md` |
| **Host** | localhost (from remote server) or 18.225.0.90 (from scripts) |
| **Database** | mandhdesign_schedular |
| **Expiry risk** | LOW — MySQL passwords don't auto-expire |
| **Verify** | `mysql -h 18.225.0.90 -u schedular -p'M1gif9!6' mandhdesign_schedular -e "SELECT 1;"` |
| **If broken** | Photo API returns errors, no uploads/deletes/listings work |

### MySQL — `AEI_User` user

| Field | Value |
|-------|-------|
| **Used by** | Direct DB queries, documentation, manual access |
| **Stored in** | `README.md`, various docs |
| **Host** | 18.225.0.90 |
| **Database** | mandhdesign_schedular |
| **Expiry risk** | LOW |
| **Verify** | `mysql -h 18.225.0.90 -u AEI_User -p'P@55w02d7777' mandhdesign_schedular -e "SELECT 1;"` |
| **If broken** | Manual DB access breaks; app unaffected |

### MySQL — `admin` user (Scheduler app)

| Field | Value |
|-------|-------|
| **Used by** | Scheduler CodeIgniter application (all controllers) |
| **Stored in** | `scheduler/system/application/config/database.php` on remote |
| **Documented in** | `DOCS/08-ADMIN_FEATURES/SYSTEM_CONFIGURATION.md` |
| **Expiry risk** | LOW |
| **If broken** | Entire scheduler application non-functional |

### MariaDB — Local `upload_user`

| Field | Value |
|-------|-------|
| **Used by** | Local upload endpoint (`/var/www/html/upload/`) |
| **Stored in** | `/var/www/html/upload/db_config.php` on local server |
| **Database** | Schedular (local) |
| **Expiry risk** | LOW |
| **Verify** | `mysql -u upload_user -p'P@55w02d778899' Schedular -e "SELECT 1;"` |
| **Privileges** | SELECT, INSERT, UPDATE, DELETE on `Schedular.*` (DELETE needed for `delete_local_photo.php`) |
| **If broken** | Local photo receipt/customer lookup/delete fails |

---

## 2. Email Credentials

### Mailtrap SMTP (Active — Scheduler Emails)

| Field | Value |
|-------|-------|
| **Used by** | All scheduler outbound email (proposals, notifications, eSign) |
| **Stored in** | `scheduler/system/libraries/Email.php` (hardcoded, not in config) |
| **Also in** | `/etc/postfix/main.cf` (relay), `EMAIL/CREDENTIALS.md` |
| **Host** | `live.smtp.mailtrap.io:587` |
| **Auth** | `smtp@mailtrap.io` / API key |
| **Expiry risk** | **HIGH** — paid service, account lapse = immediate failure |
| **Verify** | Send test email from scheduler, or: `echo "test" \| mail -s "test" admin@aeihawaii.com` from remote |
| **If broken** | All scheduler emails silently fail — proposals, notifications, eSign |
| **Rotation** | Generate new API key at mailtrap.io → update Email.php + postfix config |

### Mailjet SMTP (Legacy — Inactive)

| Field | Value |
|-------|-------|
| **Used by** | Nothing (replaced by Mailtrap) |
| **Stored in** | `scheduler/system/libraries/Email1.php` (backup file, not loaded) |
| **Also in** | `EMAIL/CREDENTIALS.md` |
| **Expiry risk** | NONE — not in use |
| **Action** | Can be removed from Email1.php; keep in docs for reference |

### Amazon SES SMTP (Legacy — Inactive)

| Field | Value |
|-------|-------|
| **Used by** | Nothing (commented out) |
| **Stored in** | `EMAIL/CREDENTIALS.md` only |
| **Expiry risk** | NONE |
| **Action** | Archive reference only |

### Gmail IMAP — Lead Creation

| Field | Value |
|-------|-------|
| **Used by** | `controllers/newcron.php` — imports leads from email |
| **Email** | `createleadmail@gmail.com` |
| **Stored in** | Hardcoded in `newcron.php` on remote server |
| **Documented in** | `EMAIL/CREDENTIALS.md`, `DOCS/04-WORKFLOWS/LEAD_MANAGEMENT.md` |
| **Expiry risk** | **HIGH** — Google blocks basic password auth; may require App Password |
| **Verify** | Check `sudo grep 'createleadmail' /var/log/cron` on remote for errors |
| **If broken** | New leads from email stop being created in scheduler |
| **Rotation** | Generate App Password at myaccount.google.com → update newcron.php |

### Gmail IMAP — Support Tickets

| Field | Value |
|-------|-------|
| **Used by** | `controllers/ticketmap.php` — imports support tickets from email |
| **Email** | `toalternateosticketsupp@gmail.com` |
| **Stored in** | Hardcoded in `ticketmap.php` on remote server |
| **Documented in** | `EMAIL/CREDENTIALS.md` |
| **Expiry risk** | **HIGH** — same Google basic auth concern |
| **Verify** | Same as above — check cron logs for IMAP errors |
| **If broken** | Email-to-ticket creation stops |

---

## 3. API Keys

### Photo API Auth Token

| Field | Value |
|-------|-------|
| **Used by** | Mobile app uploads, scheduler photo tab, all photoapi/ endpoints, delete_local_photo.php on aei-webserv2 |
| **Token** | `aei@89806849` |
| **Stored in** | Hardcoded in every photoapi/*.php file + mobile app + aei-webserv2 upload endpoints |
| **Expiry risk** | NONE — static token, never expires |
| **If broken** | All photo operations fail (upload, list, fetch, delete, local delete) |
| **Rotation** | Must update: all photoapi/ PHP files + mobile app + local upload endpoint + aei-webserv2 endpoints + QA tests |

### AWS S3 Access Key

| Field | Value |
|-------|-------|
| **Used by** | `controllers/phototab.php`, `controllers/loginapi.php` — S3 image storage |
| **Access Key** | `AKIAT7JJUULFMWZTUALA` |
| **Stored in** | Hardcoded in PHP controllers on remote |
| **Documented in** | `AEI_PHOTO_API_PROJECT/DOCS/CREDENTIALS.md`, `DOCS/07-INTEGRATIONS/AWS_INTEGRATION.md` |
| **Bucket** | `aeiimages` (eu-north-1) |
| **Expiry risk** | **HIGH** — IAM access keys have no auto-expiry but AWS recommends rotation every 90 days |
| **Verify** | `aws s3 ls s3://aeiimages/ --region eu-north-1` (requires AWS CLI with key configured) |
| **If broken** | S3-based image operations fail |
| **Rotation** | Create new IAM key → update phototab.php + loginapi.php → deactivate old key |

### Google Maps JavaScript API Key (v3 — Active)

| Field | Value |
|-------|-------|
| **Used by** | Scheduler map views, job detail pages |
| **Stored in** | `views/common/header.php` (line 36) — loaded on every page |
| **Documented in** | `DOCS/07-INTEGRATIONS/GOOGLE_MAPS_API.md` |
| **Expiry risk** | **MEDIUM** — could hit billing quota or be restricted |
| **Verify** | Load any scheduler page with a map — check browser console for errors |
| **If broken** | Maps don't load; geocoding/directions fail |
| **Rotation** | Generate new key in Google Cloud Console → update header.php |

### Google Maps JavaScript API Key (v2 — Deprecated)

| Field | Value |
|-------|-------|
| **Used by** | 60+ standalone report views |
| **Stored in** | Hardcoded in individual report view files |
| **Expiry risk** | **MEDIUM** — v2 API deprecated; may stop working |
| **If broken** | Maps in report views don't load |
| **Note** | Should be migrated to v3 key — large effort (60+ files) |

### NREL PVWatts API Key

| Field | Value |
|-------|-------|
| **Used by** | Solar performance estimates in proposals |
| **Stored in** | Controller that calls PVWatts API |
| **Documented in** | `DOCS/07-INTEGRATIONS/PVWATTS_API.md` |
| **Expiry risk** | **LOW** — NREL keys are free and long-lived |
| **If broken** | PV production estimates fail — proposals show blanks |
| **Note** | Currently uses API v5; check for deprecation notices |

---

## 4. SSH & Server Access

### SSH Private Key

| Field | Value |
|-------|-------|
| **Used by** | All SSH/SCP to remote server (admin, sync scripts, QA tests) |
| **Stored in** | `/root/.ssh/aei_production.pem` (also `SSH/schedular_server_private_key.ppk`) |
| **User** | `Julian@18.225.0.90` |
| **Expiry risk** | NONE — SSH keys don't expire |
| **If broken** | No admin access to remote server; sync scripts fail |
| **Note** | Key has no passphrase — physical security of local machine is critical |

### Local Upload Token

| Field | Value |
|-------|-------|
| **Used by** | Remote → local photo sync (sync_to_local.py) |
| **Stored in** | `/var/www/html/upload/.env` on local server |
| **Token** | `remote_token` (static) |
| **Expiry risk** | NONE — static |
| **If broken** | Photo sync from remote to local fails |

---

## 5. Third-Party Service Accounts

### Mailtrap Account

| Field | Value |
|-------|-------|
| **Service** | mailtrap.io — email delivery |
| **Used for** | All scheduler outbound email |
| **Risk** | Account lapse, billing failure, or rate limit |
| **Monitor** | Check mailtrap.io dashboard for delivery stats and account status |

### Google Cloud (Maps)

| Field | Value |
|-------|-------|
| **Service** | Google Cloud Platform — Maps JavaScript API |
| **Used for** | Map views throughout scheduler |
| **Risk** | Billing quota exceeded, API key restricted, or project deleted |
| **Monitor** | Google Cloud Console → APIs & Services → Dashboard |

### NREL Developer Network

| Field | Value |
|-------|-------|
| **Service** | developer.nrel.gov — PVWatts API |
| **Used for** | Solar production estimates |
| **Risk** | API version deprecation |
| **Monitor** | Check NREL API changelog periodically |

---

## Credential Verification Commands

Quick commands to verify all credentials are working:

```bash
# 1. MySQL (schedular user, via SSH)
ssh -i /root/.ssh/aei_production.pem Julian@18.225.0.90 \
  "mysql -u schedular -p'M1gif9!6' mandhdesign_schedular -e 'SELECT 1;'"

# 2. MySQL (AEI_User, direct)
mysql -h 18.225.0.90 -u AEI_User -p'P@55w02d7777' mandhdesign_schedular -e "SELECT 1;"

# 3. Local MariaDB
mysql -u root Schedular -e "SELECT COUNT(*) FROM unified_customers;"

# 4. Photo API token
curl -s -X POST https://aeihawaii.com/photoapi/getimagelisting.php \
  -d "auth_token=aei@89806849&job_id=0" | python3 -m json.tool

# 5. SMTP (send test email from remote)
ssh -i /root/.ssh/aei_production.pem Julian@18.225.0.90 \
  "echo 'Credential test' | mail -s 'AEI SMTP Test' admin@aeihawaii.com"

# 6. SSL certificate
echo | openssl s_client -servername aeihawaii.com -connect aeihawaii.com:443 2>/dev/null \
  | openssl x509 -noout -dates

# 7. SSH key
ssh -i /root/.ssh/aei_production.pem -o ConnectTimeout=5 Julian@18.225.0.90 "echo OK"
```

---

## Rotation Procedures

### Rotating the Mailtrap SMTP Credential

1. Log in to mailtrap.io
2. Generate new API key under Sending → SMTP Settings
3. SSH to remote: update `scheduler/system/libraries/Email.php`
4. SSH to remote: update `/etc/postfix/main.cf` (sasl_passwd)
5. Run `sudo postmap /etc/postfix/sasl_passwd && sudo service postfix reload`
6. Test: send email from scheduler

### Rotating the AWS S3 Key

1. AWS Console → IAM → Users → find the S3 user
2. Create new access key
3. SSH to remote: update `controllers/phototab.php` and `controllers/loginapi.php`
4. Verify S3 operations work
5. Deactivate old key in IAM (don't delete yet)
6. After 7 days with no issues, delete old key

### Migrating Gmail to App Passwords

1. Enable 2-Step Verification on the Gmail account
2. Go to myaccount.google.com → Security → App passwords
3. Generate app password for "Mail" on "Other"
4. SSH to remote: update the password in `controllers/newcron.php` or `controllers/ticketmap.php`
5. Test: verify leads/tickets are still imported (check cron logs)

### Rotating the Photo API Token

**High coordination required** — token is shared across:
- All `photoapi/*.php` files on remote
- Mobile app (requires app update)
- Local upload endpoint `.env`
- QA test scripts

1. Choose new token
2. Update all remote PHP files
3. Update local `.env`
4. Update mobile app and deploy
5. Update QA tests
6. Verify all endpoints work
