-- ENH-032 Phase 3: Timesheet Hardening - Database Migration
-- Run on production: mysql -u root -p mandhdesign_schedular < timesheet_phase3_migration.sql
-- Date: 2026-02-22

-- Audit trail table
CREATE TABLE IF NOT EXISTS ts_entry_audit (
    id           INT(11) NOT NULL AUTO_INCREMENT,
    entry_id     INT(11) NOT NULL,
    action       ENUM('create','edit','delete') NOT NULL,
    changed_by   INT(11) NOT NULL,
    changed_at   DATETIME NOT NULL,
    before_json  TEXT NULL,
    after_json   TEXT NULL,
    reason       VARCHAR(255) NULL DEFAULT NULL,
    PRIMARY KEY (id),
    KEY idx_entry_id (entry_id),
    KEY idx_changed_by (changed_by),
    KEY idx_changed_at (changed_at)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- Composite indexes for query performance
-- (IF NOT EXISTS not supported for indexes in MySQL 5.5, so we use a safe approach)

-- Check and add indexes on ts_time_entries
SET @idx_exists = (SELECT COUNT(*) FROM information_schema.statistics WHERE table_schema = DATABASE() AND table_name = 'ts_time_entries' AND index_name = 'idx_status_user_clockin');
SET @sql = IF(@idx_exists = 0, 'ALTER TABLE ts_time_entries ADD INDEX idx_status_user_clockin (status, user_id, clock_in)', 'SELECT 1');
PREPARE stmt FROM @sql; EXECUTE stmt; DEALLOCATE PREPARE stmt;

SET @idx_exists = (SELECT COUNT(*) FROM information_schema.statistics WHERE table_schema = DATABASE() AND table_name = 'ts_time_entries' AND index_name = 'idx_status_clockin');
SET @sql = IF(@idx_exists = 0, 'ALTER TABLE ts_time_entries ADD INDEX idx_status_clockin (status, clock_in)', 'SELECT 1');
PREPARE stmt FROM @sql; EXECUTE stmt; DEALLOCATE PREPARE stmt;

SET @idx_exists = (SELECT COUNT(*) FROM information_schema.statistics WHERE table_schema = DATABASE() AND table_name = 'ts_time_entries' AND index_name = 'idx_status_customer_clockin');
SET @sql = IF(@idx_exists = 0, 'ALTER TABLE ts_time_entries ADD INDEX idx_status_customer_clockin (status, customer_id, clock_in)', 'SELECT 1');
PREPARE stmt FROM @sql; EXECUTE stmt; DEALLOCATE PREPARE stmt;

SET @idx_exists = (SELECT COUNT(*) FROM information_schema.statistics WHERE table_schema = DATABASE() AND table_name = 'ts_time_entries' AND index_name = 'idx_user_status_clockout');
SET @sql = IF(@idx_exists = 0, 'ALTER TABLE ts_time_entries ADD INDEX idx_user_status_clockout (user_id, status, clock_out)', 'SELECT 1');
PREPARE stmt FROM @sql; EXECUTE stmt; DEALLOCATE PREPARE stmt;

-- Check and add index on ts_group_members
SET @idx_exists = (SELECT COUNT(*) FROM information_schema.statistics WHERE table_schema = DATABASE() AND table_name = 'ts_group_members' AND index_name = 'idx_user_group');
SET @sql = IF(@idx_exists = 0, 'ALTER TABLE ts_group_members ADD INDEX idx_user_group (user_id, group_id)', 'SELECT 1');
PREPARE stmt FROM @sql; EXECUTE stmt; DEALLOCATE PREPARE stmt;
