# Remote Server Maintenance Procedures

This folder contains documentation for maintenance work performed on the remote AEI Hawaii server.

---

## Maintenance Tracker

| ID | Description | Status | Date |
|----|-------------|--------|------|
| MAINT-001 | pdftemp cleanup | Complete | 2025 |
| MAINT-002 | Query optimization | Complete | 2025 |
| MAINT-003 | Comprehensive performance audit | Complete | 2025 |
| MAINT-004 | Admin calendar performance | Complete | 2026-01 |
| MAINT-005 | Job controllers optimization | Complete | 2026-01 |
| MAINT-006 | Job listing controllers | Complete | 2026-01 |
| MAINT-007 | Assign controller optimization | Complete | 2026-01 |
| MAINT-008 | Proposal performance | Complete | 2026-01 |
| MAINT-009 | Controller performance review | Complete | 2026-01 |
| MAINT-010 | Job comment 500 error | Complete | 2026-01-08 |
| MAINT-011 | Designsheet PDF readability | Complete | 2026-01 |
| MAINT-012 | Production storage cleanup (~208GB reclaimed) | Complete | 2026-02-23 |
| MAINT-013 | Dead vhosts & unused apps cleanup (~6.6GB reclaimed) | Complete | 2026-02-23 |
| MAINT-014 | Database cleanup — 125 unused tables dropped (~267MB) | Complete | 2026-02-23 |
| MAINT-015 | SSL: Let's Encrypt cert + auto-renewal + dual HTTP/HTTPS support | Complete | 2026-02-24 |

**Next ID:** MAINT-016

---

## Remote Production Environment

| Parameter | Value |
|-----------|-------|
| **Server IP** | 18.225.0.90 |
| **Domain** | aeihawaii.com |
| **SSH User** | Julian |
| **SSH Key** | `/tmp/aei_key` (convert from `CONNECTORS/SSH/schedular_server_private_key.ppk`) |
| **Web Root** | `/var/www/vhosts/aeihawaii.com/httpdocs/scheduler/` |
| **Database** | mandhdesign_schedular |
| **Platform** | AWS EC2 (Amazon Linux 2018.03) |
| **PHP** | 5.3.29 |
| **MySQL** | 5.5.62 |

---

## SSH Access Setup

```bash
# Convert PPK key to OpenSSH format (one-time)
puttygen CONNECTORS/SSH/schedular_server_private_key.ppk -O private-openssh -o /tmp/aei_key
chmod 600 /tmp/aei_key

# Connect to server
ssh -i /tmp/aei_key Julian@18.225.0.90
```

---

## Workflow Overview

### Maintenance Phases

```
1. IDENTIFY    ->  2. ANALYZE    ->  3. BACKUP     ->  4. IMPLEMENT  ->  5. VERIFY
   Issue           Review code       Create backup     Apply changes     Test on
   reported        on remote         of target files   via SSH           production
```

---

## Working with Remote Code

### View Files on Remote Server

```bash
# View a file
ssh -i /tmp/aei_key Julian@18.225.0.90 \
  "cat /var/www/vhosts/aeihawaii.com/httpdocs/scheduler/system/application/controllers/acschedule.php"

# Search for text in files
ssh -i /tmp/aei_key Julian@18.225.0.90 \
  "grep -r 'function_name' /var/www/vhosts/aeihawaii.com/httpdocs/scheduler/system/application/controllers/"

# List directory contents
ssh -i /tmp/aei_key Julian@18.225.0.90 \
  "ls -la /var/www/vhosts/aeihawaii.com/httpdocs/scheduler/system/application/controllers/"
```

### Download Files for Analysis

```bash
# Download single file
scp -i /tmp/aei_key \
  Julian@18.225.0.90:/var/www/vhosts/aeihawaii.com/httpdocs/scheduler/path/to/file.php \
  ./file.php

# Download directory
rsync -avz -e "ssh -i /tmp/aei_key" \
  Julian@18.225.0.90:/var/www/vhosts/aeihawaii.com/httpdocs/scheduler/system/application/controllers/ \
  ./controllers/
```

---

## Deployment to Production

### Prerequisites

Before deploying changes:
- [ ] Understand the current code behavior
- [ ] Plan and document the change
- [ ] Create remote backup
- [ ] Have rollback plan ready

### Deployment Process

#### Step 1: Create Remote Backup

```bash
ssh -i /tmp/aei_key Julian@18.225.0.90 \
  "cp /var/www/vhosts/aeihawaii.com/httpdocs/scheduler/path/to/file.php \
      /var/www/vhosts/aeihawaii.com/httpdocs/scheduler/path/to/file.php.bak.YYYYMMDD"
```

#### Step 2: Upload File to Remote /tmp

```bash
scp -i /tmp/aei_key \
  ./file.php \
  Julian@18.225.0.90:/tmp/file.php.new
```

#### Step 3: Deploy (Move and Copy)

Due to file permissions, use mv + cp instead of direct scp:

```bash
ssh -i /tmp/aei_key Julian@18.225.0.90 \
  "mv /var/www/vhosts/aeihawaii.com/httpdocs/scheduler/path/to/file.php \
      /var/www/vhosts/aeihawaii.com/httpdocs/scheduler/path/to/file.php.old && \
   cp /tmp/file.php.new \
      /var/www/vhosts/aeihawaii.com/httpdocs/scheduler/path/to/file.php"
```

#### Step 4: Verify and Cleanup

```bash
# Verify deployment
ssh -i /tmp/aei_key Julian@18.225.0.90 \
  "ls -la /var/www/vhosts/aeihawaii.com/httpdocs/scheduler/path/to/file.php"

# Cleanup temp files
ssh -i /tmp/aei_key Julian@18.225.0.90 \
  "rm /tmp/file.php.new \
      /var/www/vhosts/aeihawaii.com/httpdocs/scheduler/path/to/file.php.old"
```

### Post-Deployment Checklist

1. [ ] Verify file deployed correctly (check file size)
2. [ ] Test affected functionality on production
3. [ ] Monitor error logs for issues

---

## Rollback Procedure

```bash
# Restore from backup
ssh -i /tmp/aei_key Julian@18.225.0.90 \
  "cp /var/www/vhosts/aeihawaii.com/httpdocs/scheduler/path/to/file.php.bak.YYYYMMDD \
      /var/www/vhosts/aeihawaii.com/httpdocs/scheduler/path/to/file.php"
```

---

## Quick Reference

### SSH to Remote Server

```bash
ssh -i /tmp/aei_key Julian@18.225.0.90
```

### Check Error Logs

```bash
# Apache error log
ssh -i /tmp/aei_key Julian@18.225.0.90 "tail -50 /var/log/httpd/error_log"

# Application logs
ssh -i /tmp/aei_key Julian@18.225.0.90 \
  "ls -la /var/www/vhosts/aeihawaii.com/httpdocs/scheduler/system/logs/"
```

### Check Server Status

```bash
# Check services
ssh -i /tmp/aei_key Julian@18.225.0.90 "service httpd status"
ssh -i /tmp/aei_key Julian@18.225.0.90 "service mysqld status"

# Check disk/memory
ssh -i /tmp/aei_key Julian@18.225.0.90 "df -h && free -h"
```

---

## Troubleshooting

### SCP Permission Denied

If direct scp fails with "Permission denied":

```bash
# Use the mv + cp workaround:
scp -i /tmp/aei_key local_file Julian@18.225.0.90:/tmp/
ssh -i /tmp/aei_key Julian@18.225.0.90 "mv target_file target_file.old && cp /tmp/local_file target_file"
```

### SSH Connection Issues

```bash
# Test connection
ssh -i /tmp/aei_key Julian@18.225.0.90 "echo 'Connected'"

# Check key permissions
ls -la /tmp/aei_key  # Should be -rw------- (600)
```

### Verify Deployment

```bash
# Check file exists and size
ssh -i /tmp/aei_key Julian@18.225.0.90 "ls -la /path/to/file.php"

# Compare with local file
ssh -i /tmp/aei_key Julian@18.225.0.90 "md5sum /path/to/file.php"
md5sum ./file.php
```

---

## Important Notes

1. **Always create backup before modifying files**
2. **Test changes carefully - production has real user data**
3. **Keep backups for at least 30 days**
4. **Document all changes made**
5. **When in doubt, ask before proceeding**
