# MAINT-014 Changes Log

## Status: COMPLETE - 2026-02-23

---

### 2026-02-23 - Database Audit & Cleanup

**Objective:** Audit the production database for unused tables, historical snapshots, orphaned copies, and dead data. Drop tables confirmed unreferenced by application code. Sync local database and create fresh backup.

**Database:** `mandhdesign_schedular` on 18.225.0.90 (MySQL 5.5.62)

---

## Results Summary

| Metric | Before | After |
|--------|--------|-------|
| **Tables** | 463 | 335 (production) / 338 (local) |
| **DB size** | ~2,961 MB | ~2,694 MB |
| **Tables dropped** | — | 125 |
| **Space reclaimed** | — | ~267 MB |

---

## Audit Methodology

1. Queried `information_schema.tables` for all 463 tables — sizes, row counts, names
2. Identified snapshot/copy tables by naming patterns (dates, `_bak`, `_copy`, `_old`, `.sql`)
3. Identified empty tables (0 rows)
4. For each candidate table, searched application code (`SCHEDULER/` and production backup) for SQL references (`FROM`, `INTO`, `UPDATE`, `TABLE` followed by table name)
5. Verified active tables are not dropped — checked `system_price`, `ac/swh_system_price_location_2nd`, `temp_variable_job` variants, `sold_detail`, `proposal_t` (confirmed variable name only, not SQL table reference)

---

## Category 1: Unreferenced Table Copies (16 tables, ~143 MB)

Code search confirmed zero SQL references (`FROM`, `INTO`, `UPDATE`) to any of these tables across all PHP files in both local dev and production source backup.

| Table | Rows | MB | Description |
|-------|------|----|-------------|
| `jobs_copyr` | 75,223 | 49.4 | Old jobs snapshot (296 cols vs 298 in active `jobs`) |
| `jobs_15thdoc` | 83,117 | 53.8 | Old jobs snapshot |
| `proposal_t` | 40,912 | 23.5 | Old proposal copy (204 cols vs 207 in active `proposal`) |
| `ost_ticket_thread_copy` | 11,034 | 7.2 | osTicket thread backup |
| `osticket_copy` | 3,915 | 0.2 | osTicket backup |
| `ost_user_email_28thmay2025` | 18,982 | 3.3 | User email backup (May 2025) |
| `ost_user_email_copy_19thmay2025` | 19,046 | 3.3 | User email backup (May 2025) |
| `ost_user_copy_19thmay2025` | 19,095 | 1.8 | User backup (May 2025) |
| `ost_help_topic_12oct2015` | 0 | 0.1 | Old help topic backup (2015) |
| `ost_ticket_thread_new` | 127 | 0.3 | Old migration/test table |
| `ost_ticket_new` | 126 | 0.2 | Old migration/test table |
| `variable_29thjuly` | 197 | 0.3 | Old variable_job snapshot |
| `variable_copy_18dec2019` | 151 | 0.3 | Old variable_job snapshot (Dec 2019) |
| `profit_commission_22feb2022` | 921 | 0.1 | Old commission snapshot (Feb 2022) |
| `profit_commission_13nov2021` | 921 | 0.1 | Old commission snapshot (Nov 2021) |
| `sold_ids` | 0 | 0.0 | Empty, unreferenced |

---

## Category 2: Profitmargin Snapshots (19 tables, ~121 MB)

Point-in-time copies of the `profitmargin` table created manually (phpMyAdmin or CLI) as ad-hoc backups before pricing changes. The active table `profitmargin` (322,152 rows, 36 MB) was retained.

**Code verification:** Searched for `FROM profitmargin_`, `INTO profitmargin_`, `TABLE profitmargin_` — zero matches. All grep hits for `profitmargin_` in PHP code were variable names (`$sql_profitmargin_storage`, `$data["pdf_data_profitmargin_storage"]`) that query `variable_job` and `system_price_proposal`, not any snapshot table.

**Not used for tax/reporting:** These snapshots were never wired into any application code, cron jobs, or reporting tools. The naming pattern (`profitmargin_26thjuly.sql`, `profitmargin_24072023bak`) confirms they were one-off safety copies.

| Table | Rows | MB |
|-------|------|----|
| `profitmargin_6thmarch2024` | 115,659 | 13.0 |
| `profitmargin_2ndfeb2024` | 106,621 | 11.0 |
| `profitmargin_26thjuly22023` | 105,908 | 11.0 |
| `profitmargin_26thjuly.sql` | 105,908 | 11.0 |
| `profitmargin_24072023bak` | 106,074 | 10.0 |
| `profitmargin_24072023` | 105,000 | 10.0 |
| `profitmargin_12thmay2022` | 72,308 | 8.0 |
| `profitmargin16may2022` | 72,150 | 8.0 |
| `profitmargin_9thmarch2022` | 45,774 | 5.0 |
| `profitmargin_8thmarch2022` | 44,954 | 5.0 |
| `profitmargin7thmarch2022` | 42,613 | 5.0 |
| `profitmargin_4thmay2022` | 47,004 | 5.0 |
| `profitmargin_2ndmarch2021` | 39,064 | 5.0 |
| `profitmargin_2feb2022.sql` | 36,782 | 4.0 |
| `profitmargin_22feb2022` | 26,158 | 3.0 |
| `profitmargin_13nov2021` | 25,540 | 3.0 |
| `profitmargin_26thoct2021data` | 24,913 | 3.0 |
| `profitmargin26thoct2021` | 0 | 0.0 |
| `profitmargin_2oct2021` | 0 | 0.0 |

---

## Category 3: Pricing Snapshot Tables (90 tables, ~3 MB)

Historical snapshots of pricing tables across all equipment types. Small individually but 90 tables cluttering the schema. None referenced in application code.

### system_price snapshots (61 tables)

Dated copies of `system_price` and `system_price_location_2nd` ranging from 2013 to 2025. Includes variants like `system_price_bk`, `system_price_copy`, `system_price_copy_31thjan2024`, `system_price_20sept2019_bak`.

### ac_system_price snapshots (16 tables)

Dated copies including `ac_system_price_copy_7dec2020`, `ac_system_price_23june2021`, etc. Note: `ac_system_price_location_2nd` was **retained** (actively referenced in `acproposal.php`, `customers_ac.php`, `mauiacproposal.php`).

### swh_system_price snapshots (12 tables)

Dated copies from 2014-2024. Note: `swh_system_price_location_2nd` was **retained** (actively referenced in code). Active `swh_system_price_proposal` also retained.

### roof/homecharging snapshots (1 table each)

`roof_system_price_23rdmay2022` and `homecharging_system_price_18thdec2019`.

---

## Tables Verified Active (Retained)

These tables were investigated and confirmed to be actively used by application code:

| Table | Rows | MB | Reason Kept |
|-------|------|----|-------------|
| `profitmargin` | 322,152 | 36 | Active profit margin tracker |
| `system_price` | 279 | 0.02 | Active pricing table (queried in proposal.php, config.php) |
| `system_price_proposal` | 4,339,928 | 843 | Active — largest table, proposal pricing data |
| `system_price_location_2nd` | 221 | 0.04 | Active — second location pricing |
| `ac_system_price_location_2nd` | — | — | Referenced in acproposal.php, customers_ac.php |
| `swh_system_price_location_2nd` | — | — | Referenced in proposal views |
| `temp_variable_job` | 4,392 | 0.23 | Used by 82 proposal controllers/views |
| `actemp_variable_job` | 2,195 | 0.11 | Used by AC proposal controllers |
| `swh_temp_variable_job` | 1,855 | 0.11 | Used by SWH proposal controllers |
| `sold_detail` | 10,510 | 1.52 | Used by export_sold_details.php, dayview.php |
| `proposal_t` variable | — | — | `$data["proposal_t"]` is a variable name, not a table query |
| osTicket core (69 tables) | — | 613 | Last ticket created 2026-02-06, actively used |

---

## Additional Audit Findings

### 60 Empty Tables (0 rows, ~1.2 MB total)

60 tables with zero rows were identified. Not dropped in this phase because some may be actively used schema (e.g., `esign_requests`, `form_drafts` — features that exist but have no data yet, or tables populated temporarily during operations). Low priority — 1.2 MB total.

### osTicket Data (69 tables, 613 MB)

osTicket is actively used (last ticket: 2026-02-06). The `ost_file_chunk` table (332 MB) stores ticket attachments. All core osTicket tables retained. Only backup/copy tables were dropped (Category 1).

### Local vs Production Table Difference

3 empty tables exist only in local: `esign_requests`, `esign_signatures`, `form_drafts`. These were created locally but never on production. Harmless.

---

## Backup & Recovery

All dropped tables are preserved in the pre-cleanup full database backup:

```
/mnt/e/remote_scheduler_backup/database/full_backup_2026-02-23.sql.gz (648 MB)
```

To restore a single table from backup:
```bash
# Extract and restore one table
zcat full_backup_2026-02-23.sql.gz | \
  sed -n '/^-- Table structure for table `TABLE_NAME`/,/^-- Table structure for table/p' | \
  mysql -u AEI_User -p'P@55w02d7777' mandhdesign_schedular
```

---

## Database Sync

Local database was synced from production before the cleanup:
- `mysqldump` from production → imported to local MariaDB
- 463 tables, all current production data
- Both databases then had the same 125 tables dropped

---

## Related

- **MAINT-012** — Production storage cleanup (file/folder phase of the same cleanup effort)
