# MAINT-013: Dead Vhosts & Unused Apps Cleanup

## Status: COMPLETE — 2026-02-23

**Objective:** Audit `/var/www/vhosts/` on production, identify dead vhosts and unused applications, archive to local backup, and remove from production server.

**Server:** 18.225.0.90 (aeihawaii.com)
**Continuation of:** MAINT-012 (production storage cleanup)

---

## Results Summary

| Metric | Before | After |
|--------|--------|-------|
| **Disk used** | 150 GB (16%) | 143 GB (15%) |
| **Space reclaimed** | — | **~7.2 GB** |
| **Dead vhosts removed** | 3 (entire directories) | 0 |
| **Dead apps removed** | 23 | 0 |
| **Junk directories removed** | 1 (`root@62.138.26.149`) | 0 |
| **Plesk domains (still registered)** | 16 | 16 (configs in system/ only) |

---

## Audit Scope

Full audit of `/var/www/vhosts/` excluding the active production site (`aeihawaii.com/httpdocs/scheduler/`, `uploads/`, `photoappsch/`, `photoapi/`, `esign/`).

### Plesk-Registered Domains Found (16 total)

Only `aeihawaii.com` is the active production site. All others are dead:

| Domain | Has Content? | Notes |
|--------|-------------|-------|
| **aeihawaii.com** | YES (active) | Production site |
| alternateenergyhawaii.com | Had 1.7 GB | Old Drupal 7, last modified 2018 |
| staging.alternateenergyhawaii.com | Had 2.8 GB | Old Drupal 6, last modified 2015 |
| mandhdesign.com | Had 1.2 GB | Old agency site, last modified 2017 |
| 78rpmworkshop.com | Config only | No httpdocs |
| aei-staging.mygreenohana.com | Config only | No httpdocs |
| aei.mygreenohana.com | Config only | No httpdocs |
| blog.cksurfboards.com | Config only | No httpdocs |
| cksurfboards.com | Config only | No httpdocs |
| dev.alternateenergyhawaii.com | Config only | No httpdocs |
| devs.alternateenergyhawaii.com | Config only | No httpdocs |
| mandhdesign.com | Config only (after cleanup) | No httpdocs |
| mygreenhawaii.com | Config only | No httpdocs |
| mygreenohana.com | Config only | No httpdocs |
| romeosconstruction.com | Config only | No httpdocs |
| sstaging.alternateenergyhawaii.com | Config only | No httpdocs |
| zenresidence.com | Config only | No httpdocs |

---

## Phase 1: Remove Legacy Thumbnails Directory

The `scheduler/uploads/thumbnails/` directory had been emptied (377K files cleared in MAINT-012) but the empty directory remained (29 MB of filesystem metadata).

| Action | Detail |
|--------|--------|
| Path | `/var/www/vhosts/aeihawaii.com/httpdocs/scheduler/uploads/thumbnails/` |
| Files remaining | 0 (all 377K cleared previously) |
| Directory size | 29 MB (metadata only) |
| Action | `rmdir` — removed empty directory |

---

## Phase 2: Archive & Remove Dead Vhosts

Three vhosts had web content but zero files modified in the past year.

### alternateenergyhawaii.com — 1.7 GB

**What it was:** Drupal 7 website (2015 era)
- `sites/default/` — 747 MB Drupal file uploads
- `devs/` — 819 MB (duplicate copy of same Drupal install)
- Suspicious injected files: `accesson.php.suspected`, `wp-post.php`, `opn-post.php`, `teacher.php` (2018 dates, likely from compromise)
- Lead capture data: `leads/` + 4 zip files (~6 MB)

**Archive:** `dead_vhosts/alternateenergyhawaii.com.tar.gz` (1.2 GB compressed, 12,383 files)
**Removal:** Entire vhost directory removed (including logs/, error_docs/, etc.)

### staging.alternateenergyhawaii.com — 2.8 GB

**What it was:** Drupal 6 staging site (2010-2015 era)
- `files/` — 797 MB old uploads
- `downloads/` — 375 MB (96 files)
- `sites/` — 163 MB Drupal site data
- `back_up_oldifles/` (sic) — 99 MB backup of backup
- `subdomains/dev/` — 752 MB another old copy
- `.svn/` directory — ancient Subversion version control

**Archive:** `dead_vhosts/staging.alternateenergyhawaii.com.tar.gz` (2.4 GB compressed, 50,301 files)
**Note:** An additional 559 MB `httpdp.zip` (2013 zip of httpdocs) was in the vhost root, not included in the tar archive.
**Removal:** Entire vhost directory removed (including httpdp.zip, logs/, httpsdocs/, etc.)

### mandhdesign.com — 1.2 GB

**What it was:** M&H Design agency website (original developer)
- `files/` — 830 MB old project files (only 3 files)
- `scheduler/` — 183 MB **ancient copy of the scheduler** (pre-2016)
- `clientwork/` — 120 MB old client projects (aei, ck, epd, kf, mgh, mgo)
- `scitenika/` — 16 MB unrelated project

**Archive:** `dead_vhosts/mandhdesign.com.tar.gz` (994 MB compressed, 9,744 files)
**Removal:** Entire vhost directory removed (including logs/, httpsdocs/, etc.)

---

## Phase 3: Archive & Remove Dead Apps from aeihawaii.com/httpdocs

23 unused applications/directories within the production httpdocs. Activity check confirmed zero files modified in the past year (except `esign/` which was kept).

| App | Size | What It Was | Last Activity |
|-----|------|-------------|---------------|
| `crm/` | 176 MB | SugarCRM 6.3.1 (with .zip installer) | 2014 |
| `timesheet/` | 171 MB | Old standalone timesheet app | 2020 |
| `staging/` | 130 MB | Old copy of the scheduler | 2015 |
| `mediawiki/` | 90 MB | Internal wiki (MediaWiki) | 2014 |
| `support/` | 54 MB | osTicket support desk | 2013 |
| `craft/` | 49 MB | Craft CMS | 2018 |
| `hrm/` | 47 MB | OrangeHRM | 2013 |
| `newphoenix/` | 38 MB | CodeIgniter app | Unknown |
| `tracmor/` | 29 MB | Asset tracking (Tracmor) | 2013 |
| `photoapp/` | 25 MB | Old Flutter web build | 2025 (build artifacts only) |
| `scaws/` | 22 MB | Old AWS SDK 2.0.2 | 2013 |
| `downloads/` | 22 MB | Misc downloads | Unknown |
| `sticket/` | 18 MB | Another osTicket copy | 2013 |
| `cc/` | 8 MB | Old CodeIgniter app | Unknown |
| `support1/` | ~2 MB | osTicket copy | Unknown |
| `aeisupport/` | ~2 MB | osTicket copy | Unknown |
| `phoneapps/` | 1.5 MB | Old HTML mobile mockup | Unknown |
| `MySQLTuner-perl-master/` | 88 KB | MySQL tuning script | Unknown |
| `temp/` | 6 MB | Old temp directory | Unknown |
| `cmscraft/` | 20 KB | Empty CMS | Unknown |
| `timesheet1/` | 4 KB | Empty | Unknown |
| `httpdocs/` | 4 KB | Empty nested directory | Unknown |
| `font/` | 4 KB | Empty font directory | Unknown |

**Archive:** `dead_apps/aeihawaii_dead_apps.tar.gz` (327 MB compressed, 51,205 files)

---

## What Remains on Production (All Active/Under Review)

| Path | Size | Purpose | Status |
|------|------|---------|--------|
| `scheduler/` | 21 GB | Production scheduler application | **Active** |
| `uploads/` | 69 GB | Proposal/contract PDFs (105K files) | **Active** |
| `photoappsch/` | 218 MB | Photo API (CodeIgniter) | **Active** |
| `esign/` | 79 MB | E-signature app (signatures still uploading) | **Active** |
| `photoapi/` | 9.8 MB | Photo maintenance scripts | **Active** |
| `page/` | 98 MB | Contains wkhtmltopdf binary | **Needs verification** |
| `xpdfbin-linux-3.03/` | 48 MB | PDF tool binary | **Needs verification** |
| `MPDF531/` | 30 MB | mPDF library | **Needs verification** |
| `assets/` | 1.3 MB | Shared CSS/JS/images | **Active** |
| `facebox/` | 560 KB | jQuery facebox plugin | **Active** |
| `neosans/` | 256 KB | Font files | **Active** |
| `server/` | 200 KB | Server utilities | **Active** |
| `files/` | 796 KB | Misc files | **Active** |
| `curl/` | 32 KB | cURL wrapper | **Active** |
| `system/` | 3.9 MB | CodeIgniter system | **Active** |

### Items Needing Verification

- `page/wkhtmltopdf-0.11.0_rc1/` (45 MB) — May be used by scheduler PDF generation
- `xpdfbin-linux-3.03/` (48 MB) — May be used by scheduler for PDF text extraction
- `MPDF531/` (30 MB) — mPDF library, may be used by scheduler for PDF generation

These were kept pending confirmation that the scheduler does not depend on them.

---

## Local Archive Locations

All archives stored at:

```
/var/www/html/dev_scheduler/BACKUPS/PROD_ARCHIVE/
├── dead_vhosts/
│   ├── alternateenergyhawaii.com.tar.gz        (1.2 GB, 12,383 files)
│   ├── staging.alternateenergyhawaii.com.tar.gz (2.4 GB, 50,301 files)
│   └── mandhdesign.com.tar.gz                  (994 MB, 9,744 files)
├── dead_apps/
│   └── aeihawaii_dead_apps.tar.gz              (327 MB, 51,205 files)
└── README.md
```

### Archive Verification

All tar files verified readable with `tar tzf` after download:
- alternateenergyhawaii.com: 12,383 entries
- staging.alternateenergyhawaii.com: 50,301 entries
- mandhdesign.com: 9,744 entries
- dead_apps: 51,205 entries
- **Total archived: 123,633 files**

### Restoration

```bash
# Restore a dead vhost
cd /var/www/vhosts/<domain>/
sudo tar xzf /path/to/backup/<domain>.tar.gz

# Restore dead apps
cd /var/www/vhosts/aeihawaii.com/httpdocs/
sudo tar xzf /path/to/backup/aeihawaii_dead_apps.tar.gz
```

---

## Phase 4: /var/www/ Junk Cleanup

Audited `/var/www/` root for additional dead content.

### `/var/www/root@62.138.26.149/` — Removed (empty)

A directory tree mirroring the vhosts structure (aeihawaii.com, alternateenergyhawaii.com, mandhdesign.com, etc.) with **zero files** — 16 empty subdirectories. Likely created by a mistyped `scp` or `rsync` command that used `root@62.138.26.149` as a local path instead of a remote target.

- **Size:** 400 KB (directory metadata only)
- **Files:** 0
- **Action:** Deleted directly (no archive needed — nothing to preserve)

### Other `/var/www/` directories — Kept

| Directory | Size | Notes |
|-----------|------|-------|
| `html/` | 2.3 MB | Default Apache docroot + awstats |
| `cgi-bin/` | 2.4 MB | awstats CGI scripts |
| `manual/` | 1.3 MB | Apache manual |
| `icons/` | 972 KB | Apache default icons |
| `error/` | 216 KB | Apache error pages |

All are standard Apache/Plesk infrastructure directories — safe to leave.

---

## Related Items

- **MAINT-012** — Initial production storage cleanup (208 GB reclaimed, same session)
- **PHOTO-024** — Remove uploads/ root dependency (170 GB of legacy images)
