# MAINT-012 Changes Log

## Status: COMPLETE - 2026-02-23

---

### 2026-02-23 - Production Server Storage Cleanup & Optimization

**Objective:** Reclaim disk space on production AWS EC2 server by removing obsolete files, dead code directories, redundant backups, and the legacy /dev/ folder. Sync local database and create fresh backup.

**Server:** 18.225.0.90 (aeihawaii.com)

---

## Results Summary

| Metric | Before | After |
|--------|--------|-------|
| **Disk used** | 358 GB (37%) | 150 GB (16%) |
| **httpdocs/ total** | ~121 GB | 91 GB |
| **scheduler/ total** | ~50 GB | 21 GB |
| **Total disk reclaimed** | — | **~208 GB** |

---

## Phase 1: PHOTO-024 — Remove uploads/ Root Dependency (PHOTO Enhancement)

*Tracked separately as PHOTO-024 in `AEI_PHOTO_API_PROJECT/ENHANCEMENTS/PHOTO-024_remove_uploads_root_dependency/`*

Removed archive copy from `generate_thumbnails.py`, removed JPEG fallback from ZIP downloads, then deleted ~202K legacy image files (~170 GB) from `scheduler/uploads/` root after verifying all were backed up locally. 22K PDFs/docs preserved.

**Space reclaimed: ~170 GB**

---

## Phase 2: /dev/ Folder Backup & Removal

The production `/dev/` folder (8.4 GB) contained an old development copy of the scheduler. It was archived to the AEISERVER NAS and removed from production.

| Action | Detail |
|--------|--------|
| Archived to | `/mnt/aeiserver_backup/AEIHawaii.com_backup/dev_backup/` |
| Archive format | tar via SSH pipe |
| Verified | File count matched before deletion |
| Deleted from | `/var/www/vhosts/aeihawaii.com/httpdocs/dev/` |

**Space reclaimed: ~8.5 GB**

---

## Phase 3: Thumbnails Cache Purge

The `scheduler/uploads/thumbnails/` directory contained 377,000 GD-generated on-demand cache files dating back to 2013. These are **auto-regenerated** when photos are viewed in the scheduler UI — no data loss.

| Item | Value |
|------|-------|
| Files deleted | ~377,000 |
| Size | 29 GB |
| Path | `scheduler/uploads/thumbnails/` |
| Risk | None — regenerates on demand |

**Space reclaimed: ~29 GB**

---

## Phase 4: Stray SQL Dumps & Security Cleanup

Several SQL dump files were found in web-accessible directories — a security risk (database contents exposed via HTTP).

| File | Size | Date | Action |
|------|------|------|--------|
| `photoapi/sl.sql` | 290 MB | Oct 2025 | **Deleted** |
| `photoapi/sl.zip` | 52 MB | Oct 2025 | **Deleted** |
| `httpdocs/t.sql` | 57 MB | Jan 2025 | **Deleted** |
| `httpdocs/t.zip` | 3.3 MB | Jan 2025 | **Deleted** |
| `httpdocs/mae.sql` | 0 bytes | Mar 2020 | **Deleted** |

**Space reclaimed: ~402 MB**

---

## Phase 5: .bak Files & Dead Directories

### .bak Files (352 files, 24 MB)

Deployment backup files (`.bak.YYYYMMDD`, `.bak.photo024`, `.bak.maint004`, etc.) accumulated across `scheduler/system/application/`. All originals exist in the source backup at `/mnt/e/remote_scheduler_backup/source/`.

**All 352 .bak files deleted.**

### Dead Directories

| Directory | Size | Files | Description | Action |
|-----------|------|-------|-------------|--------|
| `scheduler/system/applicationbak/` | 2.3 MB | 176 | Old application backup copy | **Deleted** |
| `scheduler/system/application/controllers_lat_fixissue/` | 272 KB | 9 | Old lat/lng debugging copy | **Deleted** |
| `scheduler/assetsbak/` | 892 KB | 75 | Old assets backup | **Deleted** |

**Space reclaimed: ~27 MB**

---

## Phase 6: Archive & Remove Obsolete Directories

These items were archived locally to `dev_scheduler/BACKUPS/PROD_ARCHIVE/2026-02-23/` before deletion.

| Item | Size | Archive File | Description |
|------|------|-------------|-------------|
| `scheduler/s3uploads/` | 11 MB | `s3uploads.tar.gz` (7.2 MB) | Legacy S3 upload dir (1,218 files) |
| `httpdocs/scarpdata/` | 27 MB | `scarpdata.tar.gz` (9.3 MB) | Decommissioned scrap data (1,613 files) |
| `httpdocs/mysqldbne/` | 44 MB | `mysqldbne.tar.gz` (35 MB) | Old DB backup from 2014 |
| `uploads/` root images | ~1 GB | `uploads_images.tar.gz` (948 MB) | 1,224 stray images in non-scheduler uploads/ |
| `uploads/tempimage/` | 384 KB | `uploads_tempimage.tar.gz` (319 KB) | 5 temp image files |

**Space reclaimed: ~83 MB**

---

## Phase 7: Database Sync & Backup

| Task | Detail |
|------|--------|
| **Local DB sync** | Production → local MariaDB `mandhdesign_schedular` (463 tables) |
| **Fresh backup** | `/mnt/e/remote_scheduler_backup/database/full_backup_2026-02-23.sql.gz` (648 MB) |
| **Method** | `mysqldump` on remote via SSH, transferred via `scp` |

---

## What Remains on Production (All Active)

| Path | Size | Purpose |
|------|------|---------|
| `uploads/` root (PDFs) | ~69 GB | 104K proposal/permit PDFs referenced by DB |
| `scheduler/uploads/webp/` | 12 GB | Active WebP photo derivatives |
| `scheduler/uploads/thumbs/` | 2.4 GB | Active WebP thumbnails (200x200) |
| `scheduler/uploads/staging/` | 1.2 GB | Active upload pipeline (auto-cleaned 7 days) |
| `scheduler/pdftemp/` | 7.5 MB | Active PDF generation temp dir |
| `scheduler/temp/` | 5.8 MB | Active temp dir |
| `photoapi/logs/` | 9 MB | Active logging |

### Inactive Apps (Low Priority — Future Cleanup)

| App | Size | Last Modified |
|-----|------|--------------|
| `crm/` (SugarCRM) | 176 MB | 2014 |
| `timesheet/` | 171 MB | 2020 |
| `staging/` (old scheduler copy) | 130 MB | 2015 |
| `mediawiki/` | 90 MB | 2014 |
| Others (esign, support, craft, hrm, etc.) | ~300 MB | 2013-2018 |

Total inactive: ~870 MB — can be addressed in a future MAINT item.

---

## Local Archive Locations

| Backup | Path |
|--------|------|
| Production archives | `dev_scheduler/BACKUPS/PROD_ARCHIVE/2026-02-23/` |
| Photo backup (202K files) | `/mnt/aeiserver_backup/AEIHawaii.com_backup/photo_backup/` |
| /dev/ folder backup | `/mnt/aeiserver_backup/AEIHawaii.com_backup/dev_backup/` |
| Source code backup | `/mnt/e/remote_scheduler_backup/source/` |
| Database backups | `/mnt/e/remote_scheduler_backup/database/` |

---

## Related Enhancements

- **PHOTO-024** — Remove uploads/ root dependency (tracked in Photo API enhancements)
- **PHOTO-023** — WebP error logging, cron fallback, archive copy (precursor)
- **MAINT-014** — Database cleanup: 125 unused tables dropped (~267 MB reclaimed)
