# MAINT-011: Design Sheet PDF Readability Fix

## Problem Statement

**URL:** `http://aeihawaii.com/scheduler/admin/createnewdesignpdf/{job_id}`
**Reported:** 2026-01-15
**Issue:** When users "Create New Design Sheet" for PV Systems and AC Systems, the generated PDF text is difficult to read when printed. Field labels like "Customer Name:", "Street Address:", etc. and their values appear too light/gray.

## Root Cause

The PDF templates used:
1. **Gray color codes** (`#404040`, `#404041`, `#231f20`) instead of black (`#000000`)
2. **Ultra-light font weights** (`font-weight: 100`, `200`, `300`, `lighter`) which render text very thin

## Files Modified

| File | Change Type |
|------|-------------|
| `assets/propdf/css/style.css` | Color changes: gray to black |
| `system/application/views/proposalpdf/index.php` | Font-weight changes in inline styles |
| `system/application/views/safpdf/index.php` | Font-weight changes in inline styles |
| `system/application/views/acpdf/index.php` | Color and font-weight changes in inline styles (added 2026-01-16) |

## Detailed Changes

### 1. assets/propdf/css/style.css

Changed all gray text colors to black:

```css
/* BEFORE */
body{...color:#404041;...}
.borB{border-bottom:1px solid #404041;}
.header h1 span{ font-weight:normal; color:#404040;}
.header h2 span{ font-weight:normal; color:#404040;}
.section .heading{...color:#404040; border-bottom:2px solid #404041;...}
table.detsils td{...color:#231f20;...}
table.detsils2 td{...color:#404040;...}
table.detsils3 td{...color:#404040;...}
table.detsils3-inner td{...color:#404040;...}
table.detsils3 .whiteBG td{...color:#404040;...}
table.notes td{...color:#404040;...border-bottom:1px solid #404041;}

/* AFTER */
body{...color:#000000;...}
.borB{border-bottom:1px solid #000000;}
.header h1 span{ font-weight:normal; color:#000000;}
.header h2 span{ font-weight:normal; color:#000000;}
.section .heading{...color:#000000; border-bottom:2px solid #000000;...}
table.detsils td{...color:#000000;...}
table.detsils2 td{...color:#000000;...}
table.detsils3 td{...color:#000000;...}
table.detsils3-inner td{...color:#000000;...}
table.detsils3 .whiteBG td{...color:#000000;...}
table.notes td{...color:#000000;...border-bottom:1px solid #000000;}
```

### 2. system/application/views/proposalpdf/index.php (inline styles)

```css
/* BEFORE */
table.detsils3 td table.detsils3-inner td{font-size:18px; font-weight:300; vertical-align:middle;}
table.detsils3 td table.detsils3-inner td.greenCon{font-size:17px; font-weight:100; vertical-align:middle;}
.idtStyle{font-size:16px; font-weight:100;}
.idtStyleInput{font-size:16px; font-weight:300;}
.ssStyle{font-size:16px; font-weight:lighter;}
.ssStyleInput{font-size:16px; font-weight:300;}
table.detsils2 td{font-size:16px; font-weight:100; padding-bottom: 5px; vertical-align:top;}
.header h1 span{font-weight:200;}

/* AFTER */
table.detsils3 td table.detsils3-inner td{font-size:18px; font-weight:normal; vertical-align:middle; color:#000000;}
table.detsils3 td table.detsils3-inner td.greenCon{font-size:17px; font-weight:bold; vertical-align:middle;}
.idtStyle{font-size:16px; font-weight:bold; color:#000000;}
.idtStyleInput{font-size:16px; font-weight:normal; color:#000000;}
.ssStyle{font-size:16px; font-weight:bold; color:#000000;}
.ssStyleInput{font-size:16px; font-weight:normal; color:#000000;}
table.detsils2 td{font-size:16px; font-weight:normal; padding-bottom: 5px; vertical-align:top; color:#000000;}
.header h1 span{font-weight:normal; color:#000000;}
```

### 3. system/application/views/safpdf/index.php (inline styles)

Same changes as proposalpdf/index.php above.

### 4. system/application/views/acpdf/index.php (inline styles) - Added 2026-01-16

**URL:** `http://aeihawaii.com/scheduler/acpdf/createpdf/{job_id}`

The AC PDF template has its own inline CSS that overrides the external style.css. Changes made:

**Color changes (gray to black):**
- `color:#404041` → `color:#000000`
- `color:#414142` → `color:#000000`
- `color:#6d6e71` → `color:#000000`

**Font-weight changes:**
- `font-weight:lighter` → `font-weight:normal`
- `font-weight:100` → `font-weight:bold`
- `font-weight:300` → `font-weight:normal`

Affected CSS classes include: body, h3, h4, h5, p, .notes, .notesd, .catlt, .tdData, .dataLft, .dataRgt, .graphtable td/th, .declaraton, .declaratontext, .module, table.dataTable td, table.newTable th, .styleZoneList table td/th, and more.

## Backup Locations

### Local backups (before changes):
```
MAINT-011_designsheet_pdf_readability/backups/
├── style.css.backup
├── proposalpdf_index.php.backup
├── safpdf_index.php.backup
└── acpdf_index.php.local_original (added 2026-01-16)
```

### Remote backups (created during deployment):
```
/var/www/vhosts/aeihawaii.com/httpdocs/scheduler/
├── assets/propdf/css/style.css.bak.maint011
├── system/application/views/proposalpdf/index.php.bak.maint011
├── system/application/views/safpdf/index.php.bak.maint011
└── system/application/views/acpdf/index.php.bak.maint011 (added 2026-01-16)
```

## Rollback Procedure

If issues occur, restore from remote backups:

```bash
# SSH to server
ssh -i /tmp/aei_key Julian@18.225.0.90

# Navigate to scheduler directory
cd /var/www/vhosts/aeihawaii.com/httpdocs/scheduler

# Restore CSS
cp assets/propdf/css/style.css.bak.maint011 assets/propdf/css/style.css

# Restore PV template
cp system/application/views/proposalpdf/index.php.bak.maint011 system/application/views/proposalpdf/index.php

# Restore SAF template
cp system/application/views/safpdf/index.php.bak.maint011 system/application/views/safpdf/index.php

# Restore AC template
cp system/application/views/acpdf/index.php.bak.maint011 system/application/views/acpdf/index.php
```

## Verification Steps

1. Login to scheduler: `http://aeihawaii.com/scheduler/`
2. Navigate to any job
3. Click "Create New Design Sheet" button
4. Verify PDF generates successfully
5. Check that all text is black and readable
6. Print PDF to confirm readability on paper

## Technical Notes

- PDF generation uses `wkhtmltopdf` on production server
- Both PV and SAF templates share the same CSS file
- Font-weight values: 100-300 are very light; 400 (normal) is standard; 700 (bold) is heavy
- Green highlight sections retain green background with bold white text for contrast
