# MAINT-010 Changes Log

## Status: DEPLOYED - 2026-01-08

---

### 2026-01-08 - 500 Error on Job Comment Page

**Problem:** 500 Internal Server Error when accessing job_comment page for job ID 46051

**URL:** http://aeihawaii.com/scheduler//admin/job_comment/46051

**Reported By:** User

---

## Analysis

### Root Cause

The 500 error was caused by a **regression introduced by previous maintenance deployments**.

When we deployed optimized versions of `admin.php` during MAINT-002 through MAINT-008, we inadvertently deployed a local version that was missing the `tab_setting` helper loading.

**Production (before our maintenance) had:**
```php
$this->load->helper(array('form', 'url','tab_setting'));
```

**Our deployed version had:**
```php
$this->load->helper(array('form', 'url'));
```

The `job_comment.php` view calls `get_tab_setting()` on line 151:
```php
<?  $tab_setting_jobid=get_tab_setting();
```

This function is defined in `system/application/helpers/tab_setting_helper.php`. Without loading this helper, the function call causes a fatal "Call to undefined function" error, resulting in a 500 response.

### Why This Happened

The local development `admin.php` file was not in sync with production. It was missing:
1. `tab_setting` helper in the constructor
2. `$this->getjoblimit();` call
3. `$this->db = $this->load->database('default', true);` line

When we deployed our optimizations, we overwrote a more complete production file with an incomplete local file.

---

## Changes Made

### admin.php - Constructor (Lines 26-28)

**BEFORE:**
```php
$this->load->helper(array('form', 'url'));
```

**AFTER:**
```php
$this->getjoblimit(); // MAINT-010: Restored from production
$this->load->helper(array('form', 'url', 'tab_setting')); // MAINT-010: Restored tab_setting helper
$this->db = $this->load->database('default', true); // MAINT-010: Restored database init
```

All three lines were present in production but missing from the local development file.

---

## File Modification Log

| Date | File | Change | Status |
|------|------|--------|--------|
| 2026-01-08 | admin.php | Restored tab_setting helper in constructor | **DEPLOYED** |

---

## Backup

- Remote: admin.php.bak.maint010

---

## Rollback Plan

**Remote:**
```bash
ssh -i /tmp/aei_key Julian@18.225.0.90 "cp /var/www/vhosts/aeihawaii.com/httpdocs/scheduler/admin.php.bak.maint010 /var/www/vhosts/aeihawaii.com/httpdocs/scheduler/admin.php"
```

---

## Lessons Learned

1. **Always compare local vs production before deploying** - The local file was out of sync with production
2. **Check constructor dependencies** - Helper loading in constructors affects all controller methods
3. **Test affected pages after deployment** - The job_comment page should have been tested after admin.php changes
