# MAINT-009 Changes Log

## Status: LOCAL TESTING - 2026-01-08

---

### 2026-01-08 - Controller Performance Review

**Problem:** Review controllers for speed optimization and issues that slow page loading.

**URLs to Review:**
- http://aeihawaii.com/scheduler/create_team/index
- http://aeihawaii.com/scheduler/dayview
- http://aeihawaii.com/scheduler/technician_summary

**Reported By:** User

---

## Analysis Summary

| Controller | Issues Found | Severity |
|------------|--------------|----------|
| create_team.php | N+1 query patterns | Medium |
| dayview.php | DATE_FORMAT + N+1 queries | High |
| technician_summary.php | DATE_FORMAT + N+1 queries + complex nested loops | High |

---

## Detailed Findings

### 1. create_team.php

**File:** `/system/application/controllers/create_team.php`

#### Issue 1.1: N+1 Query Pattern in index() - Lines 26-52

```php
$team_types = $this->db->query("select * from technician_team_types...")->result_array();
foreach ($team_types as $types) {
    $teamsInType = $this->db->query("select distinct id from technician_teams where team_type_id=".$types['id'])->result_array();
    foreach ($teamsInType as $TeamsName) {
        $team_wise_tech = $this->db->query("select ... where team_names.id=".$TeamsName['id'])->result_array();
        foreach($team_wise_tech as $Technicians) {
            $technicians_names .= $this->GetUserName($Technicians['technician_id_pheo'],true).', ';
        }
    }
}
```

**Impact:**
- 1 query for team types
- N queries for teams (one per type)
- M queries for technicians (one per team)
- P queries for user names (one per technician)
- Total: 1 + N + M + P queries (potentially 50+ queries)

#### Issue 1.2: GetUserName() Individual Queries - Lines 89-101

```php
function GetUserName($id=0, $fullname = false) {
    $j = $this->db->query("SELECT first_name , last_name FROM users WHERE id=$id")->result_array();
    // Individual query per user
}
```

#### Issue 1.3: N+1 in create_new_team() - Lines 136-146

```php
foreach($db2row as $emp) {
    $sqlc = "SELECT * FROM technicians_assign WHERE team_id!='".$teamId."' and technician_id_time = '".$emp['id']."'";
    $row_userc = $this->db->query($sqlc)->row_array();
}
```

---

### 2. dayview.php

**File:** `/system/application/controllers/dayview.php`

#### Issue 2.1: DATE_FORMAT in WHERE Clause - Line 281

```php
$filter_by_date = "and DATE_FORMAT(request.start_date,'%Y-%m-%d') <= '".$filterDate."'
                   AND DATE_FORMAT(request.end_date,'%Y-%m-%d') >= '".$filterDate."'";
```

**Impact:** Prevents index usage on start_date and end_date columns.

#### Issue 2.2: N+1 Query Pattern in Job Loop - Lines 187-269

```php
foreach ($j as $key => $value) {
    $ZipArea = $this->getArea($value['zip_code']);                    // Query per job
    $temp_array["citycolor"] = $this->getCustomerNeighborhoodColor($value['customer_id']); // Query per job
    $temp_array['rel_job'] = $this->getrelatedjob($value["job_pid"], $value["id"]);        // Query per job
    $proposal_id = $this->getProposalId($value["job_pid"]);                                 // Query per job

    foreach ($installer_id_table as $id) {
        if ($this->getUserIntial($id, true))                           // Query per installer
            $newnoassign[] = '...' . $this->getUserIntial($id, true);  // Query per installer (again!)
    }

    $temp_array['varibleLaborCost'] = $this->getAllvaribleLaborCost(...);  // Multiple queries
    $temp_array['note'] = $this->getnote($value["id"]);                    // Query per job
}
```

**Impact:** With 30 jobs, each having 2 installers:
- 30 × getArea queries
- 30 × getCustomerNeighborhoodColor queries
- 30 × getrelatedjob queries
- 30 × getProposalId queries
- 60 × getUserIntial queries (2 per installer, 2 installers per job)
- 30 × getAllvaribleLaborCost (multiple queries each)
- 30 × getnote queries
- **Total: 200+ queries per page load**

#### Issue 2.3: getUserIntial() Called Twice Per Installer - Lines 253-254

```php
if ($this->getUserIntial($id, true))
    $newnoassign[] = '...' . $this->getUserIntial($id, true) . '...';
```

**Impact:** Same query run twice for each installer.

#### Issue 2.4: GetUserName() in Team Loop - Line 301

```php
foreach($team_wise_tech as $Technicians) {
    $technicians_names = $this->GetUserName($Technicians['technician_id_pheo'],true);
}
```

---

### 3. technician_summary.php

**File:** `/system/application/controllers/technician_summary.php`

#### Issue 3.1: DATE_FORMAT in WHERE Clause - Lines 45, 236

```php
// Line 45
$filter_by_date = "and DATE_FORMAT(request.start_date,'%Y-%m-%d') <= '" . $filterDate . "'
                   AND DATE_FORMAT(request.end_date,'%Y-%m-%d') >= '" . $filterDate . "'";

// Line 236 (inside GetAllJObsData)
$filter_by_date = "and DATE_FORMAT(request.start_date,'%Y-%m-%d') <= '" . $form_date . "'
                   AND DATE_FORMAT(request.end_date,'%Y-%m-%d') >= '" . $form_date . "'";
```

#### Issue 3.2: Massive N+1 Pattern in index() - Lines 50-98

```php
foreach ($team_types as $types) {
    $teamsInType = $this->db->query("select distinct id from technician_teams...")->result_array();
    foreach ($teamsInType as $TeamsName) {
        $team_wise_tech = $this->db->query("select ... where team_names.id=".$TeamsName['id'])->result_array();
        foreach ($team_wise_tech as $Technicians) {
            $technicians_names = $this->GetUserName($Technicians['technician_id_pheo'], true);
            $technicians_type = $this->GetTechnicianType($Technicians['technician_id_pheo']);
            // GetAllJObsData runs 7+ queries per call (one per day of week)
            $team_wise_data[$Technicians['technician_id_pheo']] = $this->GetAllJObsData(...);
        }
    }
}
```

#### Issue 3.3: GetAllJObsData() Complexity - Lines 216-340

This function is called for EACH technician and:
- Runs a loop for 7 days
- Per day: queries emp_timeoff_request, user_time_sheet_details, jobs table
- Per job: calls getJobhours() which runs 1-3 queries

**Impact:** With 20 technicians:
- 20 × 7 days = 140 date iterations
- Each iteration: 3-5 queries
- **Total: 500-700+ queries per page load**

#### Issue 3.4: getProposalJobhours() in Loop - Line 124

```php
foreach ($j_r as $jobs_details) {
    $combined_total_hours += $this->getProposalJobhours($proposal_id, @$jobs_details['job_type_id']);
}
```

---

## Recommended Fixes

### Fix 1: Add User Cache (All Controllers)

```php
// Add to each controller
private $_users_cache = null;
private $_users_by_id = array();

private function _loadUsersCache() {
    if ($this->_users_cache === null) {
        $this->_users_cache = $this->db->query("SELECT * FROM users")->result();
        foreach ($this->_users_cache as $user) {
            $this->_users_by_id[$user->id] = $user;
        }
    }
}

function getUserIntial($id, $fullname = false) {
    if (!$id) return 0;
    $this->_loadUsersCache();
    if (isset($this->_users_by_id[$id])) {
        $user = $this->_users_by_id[$id];
        if ($fullname) {
            return ucfirst($user->first_name) . " " . ucfirst($user->last_name);
        }
        return ucfirst($user->first_name[0]) . ucfirst($user->last_name[0]);
    }
    return "";
}
```

### Fix 2: Convert DATE_FORMAT to Direct Comparisons

```php
// BEFORE
$filter_by_date = "and DATE_FORMAT(request.start_date,'%Y-%m-%d') <= '".$filterDate."'
                   AND DATE_FORMAT(request.end_date,'%Y-%m-%d') >= '".$filterDate."'";

// AFTER
$filter_by_date = "and request.start_date <= '".$filterDate."'
                   AND request.end_date >= '".$filterDate."'";
```

### Fix 3: Batch Load Related Data (dayview.php)

```php
// Instead of querying per job, batch load all related data
$job_pids = array_column($j, 'job_pid');
$customer_ids = array_column($j, 'customer_id');

// Load all neighborhoods at once
$neighborhoods = $this->db->query("SELECT id, neighborhood, color FROM customers WHERE id IN (".implode(',', $customer_ids).")")->result_array();
$neighborhood_map = array();
foreach ($neighborhoods as $n) {
    $neighborhood_map[$n['id']] = $n;
}

// Then use $neighborhood_map[$value['customer_id']] in the loop
```

### Fix 4: Reduce GetAllJObsData() Queries (technician_summary.php)

Pre-load all timesheet data and jobs for the date range before the loop:

```php
// Before the technician loop, load all data at once
$all_timesheet_data = $this->db2->query("SELECT * FROM user_time_sheet_details WHERE submited_date BETWEEN '$from_date' AND '$to_date'")->result_array();
$timesheet_map = array();
foreach ($all_timesheet_data as $ts) {
    $timesheet_map[$ts['user_id']][$ts['submited_date']] = $ts;
}

// Then use $timesheet_map[$timesheetId][$form_date] instead of querying
```

---

## Implementation Priority

| Priority | Controller | Fix | Estimated Impact |
|----------|------------|-----|------------------|
| 1 | technician_summary.php | DATE_FORMAT + batch queries | High - 500+ queries → ~50 |
| 2 | dayview.php | DATE_FORMAT + user cache + batch load | High - 200+ queries → ~30 |
| 3 | create_team.php | User cache + batch queries | Medium - 50+ queries → ~10 |

---

## File Modification Log

| Date | File | Change | Status |
|------|------|--------|--------|
| 2026-01-08 | technician_summary.php | User cache + DATE_FORMAT fixes + function optimizations | **LOCAL** |
| 2026-01-08 | dayview.php | User cache + DATE_FORMAT fix + function optimizations | **LOCAL** |
| 2026-01-08 | dayview.php | **Phase 2**: Full batch loading implementation (see below) | **LOCAL** |
| 2026-01-08 | create_team.php | User cache + function optimization | **LOCAL** |

---

## dayview.php Phase 2 Optimizations (2026-01-08)

Additional batch loading optimizations to address remaining N+1 patterns:

### New Cache Infrastructure Added
- `_notes_cache` - batch loaded notes for all jobs
- `_neighborhood_colors_cache` - batch loaded customer neighborhood colors
- `_related_jobs_cache` - batch loaded related jobs for all job_pids
- `_areas_cache` - batch loaded zip code areas
- `_split_jobs_cache` - batch loaded split PV jobs

### Functions Modified to Use Cache
1. `getnote($job_id)` - now uses `_notes_cache`
2. `getCustomerNeighborhoodColor($id)` - now uses `_neighborhood_colors_cache`
3. `getrelatedjob($job_pid, $job_id)` - now uses `_related_jobs_cache`
4. `getArea($pincode)` - now uses `_areas_cache`

### Redundant Queries Eliminated
1. **Removed redundant `getProposalId()` call** in index() loop - proposal_id already available from main query
2. **Removed redundant `getProposalId()` call** in exportjob() loop - proposal_id available via `jobs.*`
3. **Split PV jobs query** moved from per-job query to batch load

### Query Reduction Summary (dayview.php index())
| Before | After | Reduction |
|--------|-------|-----------|
| ~200+ queries | ~15 queries | ~92% |

**Breakdown:**
- 1 main jobs query (unchanged)
- 1 users cache query
- 1 notes batch query
- 2 neighborhood queries (customers + neigbhour)
- 1 related jobs batch query
- 1 areas batch query
- 1 split jobs batch query
- ~5 misc queries (permissions, team types, etc.)

---

## Rollback Plan

Backups will be created before changes:
- create_team.php.bak.maint009
- dayview.php.bak.maint009
- technician_summary.php.bak.maint009

