# MAINT-008 Changes Log

## Status: DEPLOYED - 2026-01-08

---

### 2026-01-08 - Proposal Basic "Next" Button Performance

**Problem:** After filling out proposal_basic modal, clicking "Next" causes slow page load.

**URL:** http://aeihawaii.com/scheduler/proposal/proposal_basic

**Reported By:** User

---

## Analysis

### AJAX Flow When "Next" is Clicked

1. `proposal/checkexistcustomer` (line 6082) - Checks for duplicate address
2. `proposal/validate_propbasic` (line 786) - Validates form, inserts/updates proposal
3. `proposal/price_quote_second` (line 1397) - Loads the next page with pricing

### Issue: YEAR()/MONTH() Functions in WHERE Clauses (Index Killer)

Multiple locations in proposal.php use YEAR() and MONTH() functions on job_date in WHERE clauses, causing full table scans on the jobs table (84,160+ rows).

---

## Changes Made

### proposal.php - Converted YEAR()/MONTH() to Date Range Comparisons

**Location 1: price_quote_second() - Lines 1409-1415**
```php
// BEFORE
$sql_module_brand = "select sum(job_nom) as sumnom from jobs where year(job_date)=2013 and module_brand_id=96 and id=job_pid";
$sql_module_brand_290 = "select sum(job_nom) as sumnom from jobs where year(job_date)=2013 and module_brand_id=204 and id=job_pid";

// AFTER
$sql_module_brand = "select sum(job_nom) as sumnom from jobs where job_date >= '2013-01-01' AND job_date < '2014-01-01' and module_brand_id=96 and id=job_pid";
$sql_module_brand_290 = "select sum(job_nom) as sumnom from jobs where job_date >= '2013-01-01' AND job_date < '2014-01-01' and module_brand_id=204 and id=job_pid";
```

**Location 2: price_quote_second() - Line 1436**
```php
// BEFORE
$sqlcount = "SELECT SUM(job_nom) AS numrows FROM jobs WHERE MONTH(job_date)>5 AND YEAR(job_date)=2016 AND module_brand_id in (70,216,232,231) AND id=job_pid";

// AFTER
$sqlcount = "SELECT SUM(job_nom) AS numrows FROM jobs WHERE job_date >= '2016-06-01' AND job_date < '2017-01-01' AND module_brand_id in (70,216,232,231) AND id=job_pid";
```

**Location 3: ~Line 2330 (similar function)**
Same pattern converted to date range.

**Location 4: beforeschedulecpf() - ~Line 5978**
Same pattern converted to date range.

**Location 5: ~Line 6467 (similar function)**
Same pattern converted to date range.

**Total: 7 queries fixed across 4 functions**

---

## File Modification Log

| Date | File | Change | Status |
|------|------|--------|--------|
| 2026-01-08 | proposal.php | Convert YEAR()/MONTH() to date ranges (7 queries) | **DEPLOYED** |

---

## Backup

- Local: proposal.php.bak.maint008
- Remote: proposal.php.bak.maint008

---

## Expected Performance Improvement

- Jobs table queries can now use index on `job_date` column
- Eliminates full table scans on 84,160+ row table
- Should significantly reduce page load time on "Next" button click

---

## Rollback Plan

**Local:**
```bash
cp /var/www/html/dev_scheduler/SCHEDULER/system/application/controllers/proposal.php.bak.maint008 /var/www/html/dev_scheduler/SCHEDULER/system/application/controllers/proposal.php
```

**Remote:**
```bash
ssh -i /tmp/aei_key Julian@18.225.0.90 "cp /var/www/vhosts/aeihawaii.com/httpdocs/scheduler/system/application/controllers/proposal.php.bak.maint008 /var/www/vhosts/aeihawaii.com/httpdocs/scheduler/system/application/controllers/proposal.php"
```

