# MAINT-007 Changes Log

## Status: DEPLOYED - 2026-01-08

---

### 2026-01-08 - Assign Controller Performance Optimization

**Problem:** Assign controller pages load slowly.

**URLs to Optimize:**
- http://aeihawaii.com/scheduler/assign/myassignments
- http://aeihawaii.com/scheduler/assign/unscheduled_jobs
- http://aeihawaii.com/scheduler/assign/mycompletejobs

**Reported By:** User

---

## Analysis

### Already Fixed (MAINT-003)
- DATE_FORMAT queries already converted to direct date comparisons
- Service calls queries already optimized

### Remaining Issue: Full Table Scans on File Tables

All three functions load ENTIRE file tables into memory:

**myassignments() - Lines 188-218:**
```php
$ppfile = $this->db->get("genral_files")->result_array();      // ALL genral_files
$pmfile = $this->db->get("presale_files")->result_array();     // ALL presale_files
$permitfile = $this->db->get("permit_files")->result_array();  // ALL permit_files
$skfile = $this->db->get("sketch_files")->result_array();      // ALL sketch_files
```

**Same pattern in:**
- `unscheduled_jobs()` - Lines 594-624
- `mycompletejobs()` - Lines 996-1027

**Impact:** Loading potentially 100,000+ rows into memory when only ~30 are needed

---

## Implementation Plan

Filter file tables by job IDs from the current page:

```php
// Collect job IDs from current page results
$job_pids = array();
foreach($jobs as $j) {
    if(isset($j['job_pid'])) $job_pids[] = $j['job_pid'];
}

// Filter file queries by job IDs
if(!empty($job_pids)) {
    $this->db->where_in('job_id', $job_pids);
}
$this->db->order_by("created","desc");
$ppfile = $this->db->get("genral_files")->result_array();
```

---

## File Modification Log

| Date | File | Change | Status |
|------|------|--------|--------|
| 2026-01-08 | assign.php | Optimize file table queries in myassignments() | **DEPLOYED** |
| 2026-01-08 | assign.php | Optimize file table queries in unscheduled_jobs() | **DEPLOYED** |
| 2026-01-08 | assign.php | Optimize file table queries in mycompletejobs() | **DEPLOYED** |

---

## Rollback Plan

Backup will be created before changes.

