# MAINT-004 Changes Log

## Status: DEPLOYED - 2026-01-08 13:18 HST

---

### 2026-01-08 - Admin Calendar Performance Issue

**Problem:** The main admin calendar page (`/scheduler/admin`) loads very slowly when logged in as superadmin.

**URL:** http://aeihawaii.com/scheduler/admin

**Reported By:** User

---

## Analysis Tasks

- [x] Identify the controller function handling `/admin` route
- [x] Profile database queries in the calendar view
- [x] Check for N+1 query patterns
- [x] Check for DATE_FORMAT in WHERE clauses
- [x] Check for missing indexes on queried columns
- [x] Identify superadmin-specific code paths that may be slower

---

## Findings

### Root Cause Identified

When logged in as **superadmin**, the `/admin` route loads a special view called `salesindex.php` which includes the `saleattainment` library. This library has **severe performance issues**:

### Issue 1: DATEDIFF() in ALL WHERE Clauses (Index Killer)

Every function in `saleattainment.php` uses `DATEDIFF()` for date comparisons:

```php
// BAD - Prevents index usage, scans entire table
$seach_cond = " AND DATEDIFF(job_date,'".$searchfrom."') >= 0";
$seach_cond = " AND DATEDIFF(created,'".$searchfrom."') >= 0";
```

This forces full table scans on every query because functions on columns prevent index usage.

**Affected Functions (14 total):**
- `getTotalRevenue()` - uses DATEDIFF on `jobs.job_date`
- `getTotalPvRevenue()` - uses DATEDIFF on `jobs.job_date`
- `getH20Revenue()` - uses DATEDIFF on `jobs.job_date`
- `getAcRevenue()` - uses DATEDIFF on `jobs.job_date`
- `getNoPVProposalcreated()` - uses DATEDIFF on `proposal.created`
- `getNoPVProposalclosed()` - uses DATEDIFF on `proposal.created`
- `getNoSWHProposalcreated()` - uses DATEDIFF on `swhproposal.created`
- `getNoSWHProposalclosed()` - uses DATEDIFF on `swhproposal.created`
- `getNoACProposalclosed()` - uses DATEDIFF on `acproposal.created`
- `getoverAllClosingTotal()` - uses DATEDIFF on multiple tables
- `getoverAllCreatedTotal()` - uses DATEDIFF on multiple tables
- `getModulesTotal()` - uses DATEDIFF on `jobs.job_date`
- `getpermit()` - uses DATEDIFF on `aggdata_temp.sheet_date`

### Issue 2: N+1 Query Pattern (Query Explosion)

The `salesindex.php` view loops through ALL sales users and calls multiple functions per user:

**First Loop (lines 61-134) - Per User:**
- `getTotalRevenue()` - 1-3 queries
- `getNoPVProposalcreated()` or `getNoPVProposalclosed()` (conditional)
- `getH20Revenue()` - 1 query
- `getAcRevenue()` - 1-2 queries
- `getNoPVProposalclosed()` - 1 query
- `getNoSWHProposalclosed()` - 1 query
- `getNoACProposalclosed()` - 1 query

**Second Loop (lines 486-514) - Per User:**
- `getNoPVProposalcreated()` - 1 query
- `getNoPVProposalclosed()` - 1 query
- `getNoSWHProposalcreated()` - 1 query
- `getNoSWHProposalclosed()` - 1 query

**Modules Loop (line 591) - Per Brand Per User:**
- `getModulesTotal()` - 1 query

**Estimated Query Count:**
- If 10 sales users and 5 module brands: ~10×8 + 10×4 + 10×5 + 15 = **195+ queries per page load**
- Each query does a full table scan due to DATEDIFF

### Issue 3: Deprecated mysql_* Functions

The `getpermit()` function (line 362-400) uses deprecated `mysql_*` functions:
```php
$link=mysql_connect("localhost","scrapdb","p455word");
mysql_select_db("mandhdesign_scrapdb");
mysql_query($sql);
mysql_fetch_object($rs);
```

### Issue 4: Redundant Queries

The view calls the same functions multiple times for the same user:
- `getTotalPvRevenue($salesuser_id)` called 3 times (lines 306, 321, 336)
- `getH20Revenue($salesuser_id)` called 3 times (lines 307, 322, 337)

---

## Implementation Plan

### Phase 1: Fix DATEDIFF() Queries (High Impact)

Convert all DATEDIFF comparisons to direct date comparisons:

```php
// BEFORE (BAD)
$sql_from = "AND DATEDIFF(job_date,'".$searchfrom."') >= 0";

// AFTER (GOOD)
$sql_from = "AND job_date >= '".$searchfrom."'";
```

### Phase 2: Add Database Indexes

Check and add indexes on:
- `proposal.created`
- `swhproposal.created`
- `acproposal.created`
- `proposal.user_id` (if not exists)
- `swhproposal.user_id` (if not exists)

### Phase 3: Update Deprecated mysql_* Functions

Convert `getpermit()` to use CodeIgniter's database library with a secondary connection.

---

## Changes Made

### Phase 1: Fixed DATEDIFF() Queries in saleattainment.php

All 14 functions updated to use direct date comparisons instead of DATEDIFF():

```php
// BEFORE (prevents index usage)
$sql_from = "AND DATEDIFF(job_date,'".$searchfrom."') >= 0";

// AFTER (allows index usage)
$sql_from = "AND job_date >= '".$searchfrom."'";
```

**Functions Fixed:**
- `getTotalRevenue()` - lines 14-52
- `getTotalPvRevenue()` - lines 56-80
- `getH20Revenue()` - lines 83-106
- `getAcRevenue()` - lines 109-137
- `getNoPVProposalcreated()` - lines 139-161
- `getNoPVProposalclosed()` - lines 164-186
- `getNoSWHProposalcreated()` - lines 190-213
- `getNoSWHProposalclosed()` - lines 217-240
- `getNoACProposalclosed()` - lines 243-267
- `getoverAllClosingTotal()` - lines 269-308
- `getoverAllCreatedTotal()` - lines 311-345
- `getModulesTotal()` - lines 349-371
- `getpermit()` - lines 374-412
- Constructor date format fixed - lines 5-12

### Phase 2: Database Indexes Added

```sql
-- On proposal table (44,632 rows)
CREATE INDEX idx_user_created ON proposal(user_id, created);
CREATE INDEX idx_user_schedule_created ON proposal(user_id, is_schedule, created);

-- On swhproposal table (7,588 rows)
CREATE INDEX idx_user_created ON swhproposal(user_id, created);
CREATE INDEX idx_user_schedule_created ON swhproposal(user_id, is_schedule, created);

-- On acproposal table (14,492 rows)
CREATE INDEX idx_user_created ON acproposal(user_id, created);
CREATE INDEX idx_user_schedule_created ON acproposal(user_id, is_schedule, created);

-- On jobs table (84,160 rows)
CREATE INDEX idx_user_job_date ON jobs(user_id, job_date);
```

---

## File Modification Log

| Date | File | Change | Status |
|------|------|--------|--------|
| 2026-01-08 | saleattainment.php | Fix DATEDIFF() in 14 functions | Complete |

---

## Rollback Plan

**File Backup:**
```bash
# Restore from backup
ssh -i /tmp/aei_key Julian@18.225.0.90 "cp /var/www/vhosts/aeihawaii.com/httpdocs/scheduler/system/application/libraries/saleattainment.php.bak.maint004 /var/www/vhosts/aeihawaii.com/httpdocs/scheduler/system/application/libraries/saleattainment.php"
```

**Remove Indexes (if needed):**
```sql
DROP INDEX idx_user_created ON proposal;
DROP INDEX idx_user_schedule_created ON proposal;
DROP INDEX idx_user_created ON swhproposal;
DROP INDEX idx_user_schedule_created ON swhproposal;
DROP INDEX idx_user_created ON acproposal;
DROP INDEX idx_user_schedule_created ON acproposal;
DROP INDEX idx_user_job_date ON jobs;
```
