# MAINT-003 Changes Log

## Status: DEPLOYING - Ready for Production

---

### 2026-01-08 - Comprehensive Performance Audit & Optimization

**Analysis Scope:** Full codebase review of `/var/www/html/dev_scheduler/SCHEDULER/system/application/`

**Performance Impact:** Day view load time reduced from 2.5+ seconds to sub-second

---

## Completed Optimizations

### Phase 1: Critical Quick Wins
- [x] Fix DATE_FORMAT in assign.php (3 functions, 6+ queries)
- [x] Fix DATE_FORMAT in pvjobs.php (6 functions, 20+ queries)
- [x] Fix DATE_FORMAT in swhjobs.php (2 functions, 6 queries)
- [x] Convert in_array() to isset() lookups in admin.php (14 locations)

### Phase 2: High Priority
- [x] Fix N+1 notes queries in admin.php (day view) - reduced 50+ queries to 1
- [x] Replace self-referential HTTP calls in proposal.php (3 locations)
- [x] Fix DATE_FORMAT in getInstallerDay() function
- [x] **Add critical database indexes** (ROOT CAUSE of slowness)

### Deferred to Future
- [ ] Add LIMIT to jobs queries in admin.php
- [ ] Add API response caching for NREL PVWatts
- [ ] Migrate mysql_* calls to CodeIgniter
- [ ] Fix nested loop queries in admin.php config function

---

## File Modification Log

| Date | File | Change | Phase | Status |
|------|------|--------|-------|--------|
| 2026-01-08 | assign.php | DATE_FORMAT → date range comparisons (3 functions) | Phase 1 | Complete |
| 2026-01-08 | pvjobs.php | DATE_FORMAT → date range comparisons (6 functions) | Phase 1 | Complete |
| 2026-01-08 | swhjobs.php | DATE_FORMAT → date range comparisons (2 functions) | Phase 1 | Complete |
| 2026-01-08 | admin.php | in_array() → isset() with array_flip (14 locations) | Phase 1 | Complete |
| 2026-01-08 | admin.php | N+1 notes queries → single batched query | Phase 2 | Complete |
| 2026-01-08 | admin.php | getInstallerDay() DATE_FORMAT fix | Phase 2 | Complete |
| 2026-01-08 | proposal.php | Self-referential HTTP → direct file/view access | Phase 2 | Complete |

---

## Database Changes (CRITICAL)

**These indexes must be applied to production database:**

```sql
-- Index on jobs.job_date - CRITICAL for day view performance
CREATE INDEX idx_job_date ON jobs(job_date);

-- Composite index for job type queries
CREATE INDEX idx_job_date_type ON jobs(job_date, job_type_id);

-- Index on service_calls.date
CREATE INDEX idx_date ON service_calls(date);

-- Index on installer_manual.day
CREATE INDEX idx_day ON installer_manual(day);
```

**Impact:** Reduced query scans from 84,160 rows to ~3-12 rows per query

---

## Files to Deploy

1. `/SCHEDULER/system/application/controllers/admin.php`
2. `/SCHEDULER/system/application/controllers/assign.php`
3. `/SCHEDULER/system/application/controllers/pvjobs.php`
4. `/SCHEDULER/system/application/controllers/swhjobs.php`
5. `/SCHEDULER/system/application/controllers/proposal.php`

---

## Rollback Plan

**Files:** Backups stored in `MAINT-003_comprehensive_performance_audit/backups/`

**Database:** To remove indexes if needed:
```sql
DROP INDEX idx_job_date ON jobs;
DROP INDEX idx_job_date_type ON jobs;
DROP INDEX idx_date ON service_calls;
DROP INDEX idx_day ON installer_manual;
```

---

## Deployment Checklist

- [ ] Backup remote files before deployment
- [ ] Deploy 5 PHP files via SCP/SFTP
- [ ] Run 4 CREATE INDEX statements on production database
- [ ] Test day view performance on production
- [ ] Verify all job listings work correctly
