# MAINT-002 Changes Log

## Status: DEPLOYED - Optimizations Deployed to Production

---

### 2026-01-08 - Phase 1 & 2 Implementation

**Files Modified:**
1. `system/application/controllers/admin.php`
2. `system/application/libraries/Job.php`

**Backups Created:**
- `backups/admin.php.backup` (685KB)
- `backups/Job.php.backup` (21KB)

---

## Changes Implemented

### Phase 1: DATE_FORMAT() Replacements

**admin.php - index() function:**
- Lines 55-68: Added `$idx_month_start` and `$idx_month_end` variables
- Replaced DATE_FORMAT queries with date range comparisons for:
  - jobs table query
  - service_calls table query

**admin.php - jobschedule() function:**
- Lines 513-553: Added `$month_start` and `$month_end` variables
- Replaced DATE_FORMAT queries for:
  - stickynote query
  - jobs query
  - service_calls query
  - admin_block_date query

**admin.php - day() function:**
- Line 1300: Added `$day_date` variable
- Replaced 14 DATE_FORMAT queries with direct date comparisons:
  - PV jobs (job_type_id=2)
  - SWH jobs (job_type_id=1)
  - SAF jobs (job_type_id=3)
  - Prelag jobs (job_type_id=6)
  - PM jobs (job_type_id=7)
  - AC jobs (job_type_id in 5,26)
  - EV jobs (job_type_id=25)
  - Roofing jobs (job_type_id=8)
  - Battery jobs (job_type_id=15)
  - Windows jobs (job_type_id=16)
  - GC jobs (job_type_id=9,20,21,17,23)
  - Job count query
  - Service call count query

**Job.php library:**
- Lines 14-20: Fixed total() function DATE_FORMAT queries
- Lines 33-38: Fixed sc_total() function DATE_FORMAT queries

### Phase 1: Installer/Contractor Caching

**admin.php - day() function:**
- Lines 1302-1308: Added preloaded `$_cached_installers` and `$_cached_contractors`
- Replaced ~12 repeated installer queries with cached lookups
- Replaced ~6 repeated conduit queries with cached lookups
- Replaced contractor queries with cached lookups

### Phase 2: User/Customer/Color Caching

**admin.php - Added cache properties (lines 5-12):**
```php
private $_users_cache = null;
private $_users_by_id = null;
private $_customers_cache = null;
private $_customers_by_id = null;
private $_colors_cache = null;
private $_colors_by_id = null;
private $_installers_cache = null;
```

**admin.php - Added cache loading functions:**
- `_loadUsersCache()` - Lines 8902-8911
- `_loadColorsCache()` - Lines 8134-8143
- `_loadCustomersCache()` - Lines 8075-8084
- `_loadNeighbourhoodsCache()` - Lines 8103-8111

**admin.php - Modified helper functions to use cache:**
- `getuser()` - Now uses `_users_by_id` cache (Lines 8913-8937)
- `getUserIntial()` - Now uses `_users_by_id` cache (Lines 8141-8124)
- `getUserColor()` - Now uses `_users_by_id` and `_colors_by_id` caches (Lines 8145-8168)
- `getCustomerLastname()` - Now uses `_customers_by_id` cache (Lines 8086-8098)
- `getCustomerNeighborhood()` - Now uses `_customers_by_id` and `_neighbourhoods_by_id` caches (Lines 8113-8140)

---

## Estimated Query Reduction

| Page | Before | After | Reduction |
|------|--------|-------|-----------|
| /admin/day (10 jobs) | ~70-100 | ~15-20 | ~80% |
| /admin/jobschedule | ~50-80 | ~10-15 | ~80% |

---

## Testing Checklist

### Functional Testing
- [ ] Login works correctly
- [ ] Calendar displays correctly (/admin/jobschedule)
- [ ] Day view loads (/admin/day/2026/01/08)
- [ ] All job types display
- [ ] User names display correctly
- [ ] Colors display correctly
- [ ] Customer names display correctly
- [ ] Neighborhoods display correctly

### Performance Testing
- [ ] Page load time improved for jobschedule
- [ ] Page load time improved for day view
- [ ] No PHP errors in logs
- [ ] No database errors

---

## Rollback Instructions

If issues are found:
```bash
# Restore admin.php
cp /var/www/html/AEI_REMOTE/WORK/MAINT-002_query_optimization/backups/admin.php.backup \
   /var/www/html/dev_scheduler/SCHEDULER/system/application/controllers/admin.php

# Restore Job.php
cp /var/www/html/AEI_REMOTE/WORK/MAINT-002_query_optimization/backups/Job.php.backup \
   /var/www/html/dev_scheduler/SCHEDULER/system/application/libraries/Job.php
```

---

## Deployment Log

### 2026-01-08 - Production Deployment

**Remote Backups Created:**
- `backups/remote/admin.php.remote_backup` - Original production admin.php
- `backups/remote/Job.php.remote_backup` - Original production Job.php

**Files Deployed:**
```
scp admin.php -> /var/www/vhosts/aeihawaii.com/httpdocs/dev/scheduler/system/application/controllers/admin.php
scp Job.php -> /var/www/vhosts/aeihawaii.com/httpdocs/dev/scheduler/system/application/libraries/Job.php
```

**Verification:**
- admin.php: 28 MAINT-002 optimization comments present
- Job.php: 3 MAINT-002 optimization comments present

---

## Rollback Instructions (Production)

If issues are found on production:
```bash
# SSH to remote server
ssh -i /tmp/aei_key Julian@18.225.0.90

# Restore admin.php from local backup
scp -i /tmp/aei_key /var/www/html/AEI_REMOTE/WORK/MAINT-002_query_optimization/backups/remote/admin.php.remote_backup \
    Julian@18.225.0.90:/var/www/vhosts/aeihawaii.com/httpdocs/dev/scheduler/system/application/controllers/admin.php

# Restore Job.php from local backup
scp -i /tmp/aei_key /var/www/html/AEI_REMOTE/WORK/MAINT-002_query_optimization/backups/remote/Job.php.remote_backup \
    Julian@18.225.0.90:/var/www/vhosts/aeihawaii.com/httpdocs/dev/scheduler/system/application/libraries/Job.php
```
