# MAINT-001: PDF Temp Files Cleanup - Changes

**Created:** 2026-01-07
**Completed:** 2026-01-07
**Status:** COMPLETED (Steps 1-4)

---

## Summary

This maintenance item addresses the accumulation of 50,853+ temp files (6GB) in the `pdftemp` folder due to buggy cleanup code and missing scheduled maintenance.

---

## Planned Changes

### Change 1: Manual Cleanup of Existing Files

**Type:** One-time cleanup
**Risk Level:** Low
**Location:** Remote server via SSH

**Commands to execute:**
```bash
# 1. First, check current state
ls /var/www/vhosts/aeihawaii.com/httpdocs/dev/scheduler/pdftemp/ | wc -l
du -sh /var/www/vhosts/aeihawaii.com/httpdocs/dev/scheduler/pdftemp/

# 2. Preview HTML files to delete (older than 1 day)
find /var/www/vhosts/aeihawaii.com/httpdocs/dev/scheduler/pdftemp -name "*.html" -type f -mtime +1 | wc -l

# 3. Preview PDF files to delete (older than 30 days)
find /var/www/vhosts/aeihawaii.com/httpdocs/dev/scheduler/pdftemp -name "*.pdf" -type f -mtime +30 | wc -l

# 4. Delete old HTML files (intermediate files, safe to remove)
find /var/www/vhosts/aeihawaii.com/httpdocs/dev/scheduler/pdftemp -name "*.html" -type f -mtime +1 -delete

# 5. Delete old PDF files (keep 30 days for safety)
find /var/www/vhosts/aeihawaii.com/httpdocs/dev/scheduler/pdftemp -name "*.pdf" -type f -mtime +30 -delete

# 6. Verify cleanup
ls /var/www/vhosts/aeihawaii.com/httpdocs/dev/scheduler/pdftemp/ | wc -l
du -sh /var/www/vhosts/aeihawaii.com/httpdocs/dev/scheduler/pdftemp/
```

**Rollback:** N/A - Files being deleted are orphaned temp files

---

### Change 2: Add Scheduled Cleanup Cron Job

**Type:** New cron job
**Risk Level:** Low
**Location:** Server crontab or Plesk scheduled tasks

**Script to create:** `/var/www/vhosts/aeihawaii.com/httpdocs/dev/scheduler/scripts/cleanup_pdftemp.sh`

```bash
#!/bin/bash
# cleanup_pdftemp.sh - Clean up old PDF temp files
# Run daily at 2 AM

PDFTEMP_DIR="/var/www/vhosts/aeihawaii.com/httpdocs/dev/scheduler/pdftemp"
ESIGN_PDFTEMP="/var/www/vhosts/aeihawaii.com/httpdocs/esign/upload/pdftemp"
LOG_FILE="/var/log/pdftemp_cleanup.log"

echo "$(date): Starting pdftemp cleanup" >> "$LOG_FILE"

# Count before
BEFORE_COUNT=$(ls "$PDFTEMP_DIR" 2>/dev/null | wc -l)

# Delete HTML files older than 1 day
find "$PDFTEMP_DIR" -name "*.html" -type f -mtime +1 -delete 2>/dev/null

# Delete PDF files older than 7 days
find "$PDFTEMP_DIR" -name "*.pdf" -type f -mtime +7 -delete 2>/dev/null

# Clean esign pdftemp too
find "$ESIGN_PDFTEMP" -name "*.html" -type f -mtime +1 -delete 2>/dev/null
find "$ESIGN_PDFTEMP" -name "*.pdf" -type f -mtime +7 -delete 2>/dev/null

# Count after
AFTER_COUNT=$(ls "$PDFTEMP_DIR" 2>/dev/null | wc -l)

echo "$(date): Cleanup complete. Before: $BEFORE_COUNT, After: $AFTER_COUNT" >> "$LOG_FILE"
```

**Crontab entry:**
```
0 2 * * * /var/www/vhosts/aeihawaii.com/httpdocs/dev/scheduler/scripts/cleanup_pdftemp.sh
```

**Rollback:** Remove cron entry and delete script

---

### Change 3: Fix Unlink Bug in PHP Controllers (OPTIONAL - Code Fix)

**Type:** Code modification
**Risk Level:** Medium
**Status:** DEFERRED - Recommend cron cleanup instead

If code fix is desired, the following files need modification:

#### File: `system/application/controllers/proposal.php`

**Location 1: Lines ~4190-4191**

Before:
```php
unlink("/var/www/vhosts/aeihawaii.com/httpdocs/dev/scheduler/pdftemp/temp$t.html");
unlink("/var/www/vhosts/aeihawaii.com/httpdocs/dev/scheduler/pdftemp/proposal$t.pdf");
```

After:
```php
@unlink("/var/www/vhosts/aeihawaii.com/httpdocs/dev/scheduler/pdftemp/temp$t-$proposal_id.html");
@unlink("/var/www/vhosts/aeihawaii.com/httpdocs/dev/scheduler/pdftemp/footer$footer_t-$proposal_id.html");
@unlink("/var/www/vhosts/aeihawaii.com/httpdocs/dev/scheduler/pdftemp/proposal$t-$proposal_id.pdf");
```

**Location 2: Lines ~7367-7368** - Same fix as above

**Location 3: Lines ~7489-7490** - Same fix as above

#### File: `system/application/controllers/esign.php`

**Locations:** Lines ~1764-1765, ~5031-5032, ~5146-5147
**Fix:** Same pattern as proposal.php

#### File: `system/application/controllers/cron.php`

**Location:** Lines ~1730-1731
**Fix:** Same pattern as proposal.php

#### Additional Files Requiring Same Fix:
- `acproposal.php`
- `acpdf.php`
- `adminpartpdf.php`
- `actabpartpdf.php`
- `drwproposal.php`
- `roofproposal.php`
- `safproposal.php`
- `swhproposal.php`
- `gcesign.php`
- `evesign.php`
- `roofesign.php`
- `safesign.php`
- `swhesign.php`
- `acesign.php`

**Rollback:** Restore files from `backups/` folder

---

## Files to Backup Before Code Changes

If proceeding with code fixes (Change 3), backup these files first:

```
system/application/controllers/proposal.php
system/application/controllers/esign.php
system/application/controllers/cron.php
system/application/controllers/acproposal.php
system/application/controllers/acpdf.php
system/application/controllers/adminpartpdf.php
system/application/controllers/actabpartpdf.php
system/application/controllers/drwproposal.php
system/application/controllers/roofproposal.php
system/application/controllers/safproposal.php
system/application/controllers/swhproposal.php
system/application/controllers/gcesign.php
system/application/controllers/evesign.php
system/application/controllers/roofesign.php
system/application/controllers/safesign.php
system/application/controllers/swhesign.php
system/application/controllers/acesign.php
```

---

## Implementation Order

### Phase 1: Immediate Relief (Recommended)
1. [x] Manual cleanup of old files (Change 1) - DONE 2026-01-07
2. [x] Verify disk space recovered - DONE 2026-01-07

### Phase 2: Prevention (Recommended)
3. [x] Create and deploy cleanup script (Change 2) - DONE 2026-01-07
4. [x] Add cron job - DONE 2026-01-07
5. [ ] Monitor for 1 week

### Phase 3: Code Fix (Optional/Deferred)
6. [ ] Backup all PHP files
7. [ ] Apply fixes to each controller
8. [ ] Test PDF generation
9. [ ] Monitor cleanup behavior

---

## Verification Steps

After implementation:

1. **After Change 1:**
   - Verify file count reduced
   - Verify disk space recovered
   - Verify application still works (test PDF generation)

2. **After Change 2:**
   - Verify cron job is scheduled
   - Wait 24 hours, check log file
   - Verify old files are being cleaned

3. **After Change 3 (if implemented):**
   - Generate a new proposal PDF
   - Check pdftemp folder - new temp files should be cleaned
   - Verify no errors in application

---

## Rollback Procedures

### Rollback Change 1
Not applicable - deleted files were orphaned temp files

### Rollback Change 2
```bash
# Remove cron entry
crontab -e  # Delete the cleanup line

# Delete script
rm /var/www/vhosts/aeihawaii.com/httpdocs/dev/scheduler/scripts/cleanup_pdftemp.sh
```

### Rollback Change 3
```bash
# Restore each backed up file
cp ./backups/proposal.php /var/www/vhosts/aeihawaii.com/httpdocs/dev/scheduler/system/application/controllers/proposal.php
# Repeat for each modified file
```

---

## Notes

- The cron-based cleanup (Change 2) is the safest and most effective solution
- Code fixes (Change 3) are optional since the cron job will handle cleanup
- Consider monitoring disk space after implementation
- The `mail_sent/` folder stores intentional copies - do not clean this folder

---

## Implementation Log (2026-01-07)

### Manual Cleanup Results

| Location | Before | After | Cleaned |
|----------|--------|-------|---------|
| Main pdftemp | 29,170 files (2.5GB) | 280 files (33MB) | 28,890 files (~2.5GB) |
| Esign pdftemp | 4,156 files | 4 files | 4,152 files |

### Deployed Components

1. **Cleanup Script**: `/var/www/vhosts/aeihawaii.com/httpdocs/dev/scheduler/scripts/cleanup_pdftemp.sh`
2. **Log File**: `/var/www/vhosts/aeihawaii.com/httpdocs/dev/scheduler/logs/pdftemp_cleanup.log`
3. **Cron Job**: `0 2 * * *` (runs daily at 2 AM server time)

### Retention Policy Applied
- HTML files: Deleted after 1 day
- PDF files: Deleted after 7 days
