# AEI Scheduler Remote Server Documentation

This document provides comprehensive documentation of the AEI Scheduler production server for troubleshooting and maintenance.

## Quick Reference

| Item | Value |
|------|-------|
| **Public IP** | 18.225.0.90 |
| **Internal Hostname** | ip-172-31-39-5 |
| **Domain** | aeihawaii.com |
| **SSH User** | Julian |
| **SSH Key** | `CONNECTORS/SSH/schedular_server_private_key.ppk` |
| **Database** | mandhdesign_schedular |
| **Platform** | AWS EC2 (Amazon Linux AMI 2018.03) |

---

## SSH Access

### Connection Details

```bash
# From Linux/Mac (convert PPK to OpenSSH format first)
puttygen CONNECTORS/SSH/schedular_server_private_key.ppk -O private-openssh -o /tmp/aei_key
chmod 600 /tmp/aei_key
ssh -i /tmp/aei_key Julian@18.225.0.90

# From Windows
# Use PuTTY with the .ppk key directly
```

### Important Notes

- Username is `Julian` (capital J) - Linux is case-sensitive
- The PPK key must be converted to OpenSSH format for Linux/Mac SSH clients
- Use `puttygen` (install with `apt install putty-tools`) to convert

---

## Server Architecture

### System Information

| Component | Details |
|-----------|---------|
| **OS** | Amazon Linux AMI 2018.03 |
| **Kernel** | 4.14.328-174.540.amzn1.x86_64 |
| **Web Server** | Apache 2.4.61 (httpd24, mod_php7 prefork) |
| **PHP Version** | 7.3.30 (upgraded from 5.3.29 on 2026-02-23) |
| **PHP-FPM** | 7.3 running (backup handler) |
| **MySQL Version** | 5.5.62 |
| **DB Driver** | mysqli (changed from mysql) |
| **Architecture** | x86_64 |

### Hardware Resources

| Resource | Value |
|----------|-------|
| **RAM** | 7.8 GB total, ~4.8 GB available |
| **Disk** | 985 GB total, 653 GB available (34% used) |
| **Uptime** | Long-running (267+ days as of last check) |

### Network Configuration

| Port | Service | Purpose |
|------|---------|---------|
| 22 | SSH | Secure shell access |
| 80 | HTTP | Web traffic (default) |
| 443 | HTTPS | Secure web traffic |
| 3306 | MySQL | Database connections |
| 10000 | Webmin | Server management panel |

---

## Website Structure

### Virtual Hosts

The main website is hosted at:
```
/var/www/vhosts/aeihawaii.com/httpdocs/
```

### SSL Configuration

- **Certificate Provider**: Let's Encrypt (switched from GoDaddy on 2026-02-24)
- **Certificate Path**: `/etc/letsencrypt/live/aeihawaii.com/` (fullchain.pem, privkey.pem)
- **Config File**: `/etc/httpd/conf.d/ssl.conf`
- **Auto-Renewal**: Cron at `/etc/cron.d/certbot` (runs 2x daily at 03:00 and 15:00)
- **Certbot**: `/usr/local/bin/certbot` v1.23.0 (pip, Python 3.6, pyOpenSSL 23.1.1)
- **Protocol**: Dual HTTP/HTTPS — site defaults to HTTP, HTTPS works when accessed directly
- **Previous Cert**: GoDaddy/Starfield at `/etc/ssl/aeihawaii.com/godaddy/` (valid until 2027-02-18, preserved as fallback)
- **Config Backup**: `/etc/httpd/conf.d/ssl.conf.bak.godaddy` (original GoDaddy ssl.conf)
- **htaccess Backup**: `.htaccess.bak.pre_https` in scheduler root (had HTTPS→HTTP force redirect)

### Directory Structure

```
/var/www/vhosts/aeihawaii.com/httpdocs/
├── scheduler/          # Main Scheduler Application (CodeIgniter)
│   ├── index.php       # Application entry point
│   ├── admin.php       # Admin interface
│   ├── ajax.php        # AJAX handlers
│   ├── login.php       # Authentication
│   ├── system/         # CodeIgniter framework
│   │   ├── application/
│   │   │   ├── controllers/   # PHP controllers
│   │   │   ├── models/        # Database models
│   │   │   ├── views/         # Template views
│   │   │   └── config/        # App configuration
│   │   ├── database/   # Database drivers
│   │   └── libraries/  # CodeIgniter libraries
│   ├── assets/         # CSS, JS, images
│   ├── s3uploads/      # AWS S3 file uploads
│   └── MPDF531/        # PDF generation library
│
├── support/            # osTicket Support System
│   ├── index.php
│   ├── api/
│   ├── scp/           # Staff control panel
│   └── include/       # osTicket core
│
├── esign/              # E-signature system
├── crm/                # CRM module
├── hrm/                # HR management
├── aeisupport/         # Legacy support
└── files/              # Uploaded files
```

### Other Virtual Hosts

| Domain | Path |
|--------|------|
| aeihawaii.com | `/var/www/vhosts/aeihawaii.com/` |
| alternateenergyhawaii.com | `/var/www/vhosts/alternateenergyhawaii.com/` |
| mandhdesign.com | `/var/www/vhosts/mandhdesign.com/` |
| staging.alternateenergyhawaii.com | `/var/www/vhosts/staging.alternateenergyhawaii.com/` |

---

## Scheduler Application

### Technology Stack

| Component | Technology |
|-----------|------------|
| **Framework** | CodeIgniter (PHP MVC) |
| **PHP Version** | 7.3.30 |
| **Database** | MySQL 5.5 (mysqli driver) |
| **PDF Library** | MPDF 5.3.1 |
| **JavaScript** | jQuery |

### Key Files

| File | Purpose |
|------|---------|
| `scheduler/index.php` | Main entry point, job calendar |
| `scheduler/admin.php` | Admin dashboard |
| `scheduler/ajax.php` | AJAX request handlers |
| `scheduler/login.php` | User authentication |
| `scheduler/system/application/config/database.php` | Database configuration |

### Controllers (Key Ones)

| Controller | Purpose |
|------------|---------|
| `acschedule.php` | AC scheduling and calendar |
| `acproposal.php` | Proposal generation |
| `acpdf.php` | PDF document generation |
| `acesign.php` | E-signature integration |
| `acreport.php` | Reporting |
| `acinventory.php` | Inventory management |

### URL Structure

- **Main App**: `https://aeihawaii.com/scheduler/`
- **Login**: `https://aeihawaii.com/scheduler/login.php`
- **Admin**: `https://aeihawaii.com/scheduler/admin.php`
- **Support**: `https://aeihawaii.com/support/`

---

## Database

### Connection Details

| Parameter | Value |
|-----------|-------|
| **Host** | 18.225.0.90 (or `localhost` from server) |
| **Port** | 3306 |
| **Database** | mandhdesign_schedular |
| **Read-Only User** | AEI_User |
| **Password** | P@55w02d7777 |

### Testing Connection

```bash
# From remote machine
mysql -h 18.225.0.90 -u AEI_User -p'P@55w02d7777' mandhdesign_schedular \
  -e "SELECT COUNT(*) as customers FROM customers;"

# From the server itself
mysql -u root mandhdesign_schedular -e "SHOW TABLES;"
```

### Key Tables

| Table | Records | Purpose |
|-------|---------|---------|
| customers | 17,000+ | Customer master data |
| jobs | 84,000+ | All scheduled work |
| notes | 191,000+ | Activity logs |
| proposal | 44,600+ | Sales quotes |
| users | - | System users/employees |
| job_types | - | Job type lookup |

See `AEI_DATABASE_SCHEMA.md` for complete schema documentation.

---

## Troubleshooting Guide

### Common Issues

#### 1. Website Not Loading

**Check Apache status:**
```bash
ssh -i /tmp/aei_key Julian@18.225.0.90 "service httpd status"
```

**Restart Apache:**
```bash
ssh -i /tmp/aei_key Julian@18.225.0.90 "sudo service httpd restart"
```

**Check error logs:**
```bash
ssh -i /tmp/aei_key Julian@18.225.0.90 "tail -50 /var/log/httpd/error_log"
```

#### 2. Database Connection Issues

**Check MySQL status:**
```bash
ssh -i /tmp/aei_key Julian@18.225.0.90 "service mysqld status"
```

**Test connection:**
```bash
ssh -i /tmp/aei_key Julian@18.225.0.90 "mysql -u root -e 'SHOW DATABASES;'"
```

**Check MySQL error log:**
```bash
ssh -i /tmp/aei_key Julian@18.225.0.90 "tail -50 /var/log/mysqld.log"
```

#### 3. SSL Certificate Issues

**Check current certificate (Let's Encrypt):**
```bash
# From anywhere — check live cert
echo | openssl s_client -servername aeihawaii.com -connect aeihawaii.com:443 2>/dev/null \
  | openssl x509 -noout -dates -issuer -subject

# From production — check cert file
ssh -i /tmp/aei_key Julian@18.225.0.90 \
  "openssl x509 -in /etc/letsencrypt/live/aeihawaii.com/fullchain.pem -noout -dates"
```

**Test auto-renewal:**
```bash
ssh -i /tmp/aei_key Julian@18.225.0.90 "sudo /usr/local/bin/certbot renew --dry-run"
```

**Rollback to GoDaddy cert (if needed):**
```bash
ssh -i /tmp/aei_key Julian@18.225.0.90 \
  "sudo cp /etc/httpd/conf.d/ssl.conf.bak.godaddy /etc/httpd/conf.d/ssl.conf && sudo service httpd reload"
```

**Restart Apache after cert update:**
```bash
ssh -i /tmp/aei_key Julian@18.225.0.90 "sudo service httpd restart"
```

#### 4. Disk Space Issues

**Check disk usage:**
```bash
ssh -i /tmp/aei_key Julian@18.225.0.90 "df -h"
```

**Find large files:**
```bash
ssh -i /tmp/aei_key Julian@18.225.0.90 "du -sh /var/www/vhosts/aeihawaii.com/httpdocs/* | sort -hr | head -20"
```

#### 5. PHP Errors

**Check PHP error log:**
```bash
ssh -i /tmp/aei_key Julian@18.225.0.90 "tail -100 /var/log/httpd/error_log | grep -i php"
```

**Check PHP configuration:**
```bash
ssh -i /tmp/aei_key Julian@18.225.0.90 "php -i | grep -E 'memory_limit|max_execution|upload_max'"
```

### Log File Locations

| Log | Path |
|-----|------|
| Apache Error | `/var/log/httpd/error_log` |
| Apache Access | `/var/log/httpd/access_log` |
| MySQL Error | `/var/log/mysqld.log` |
| System Messages | `/var/log/messages` |
| CodeIgniter Logs | `/var/www/vhosts/aeihawaii.com/httpdocs/scheduler/system/logs/` |

### Useful Commands

```bash
# Check running processes
ps aux | grep -E 'httpd|mysql'

# Check memory usage
free -h

# Check load average
uptime

# List active connections
netstat -an | grep ESTABLISHED | wc -l

# Check PHP modules
php -m

# Check Apache modules
httpd -M
```

---

## Security Notes

1. **SSH Access**: Only key-based authentication (no password login)
2. **Database**: Remote read-only access via AEI_User; root access only from localhost
3. **SSL**: Let's Encrypt certificate with auto-renewal; dual HTTP/HTTPS (no forced redirect)
4. **Firewall**: AWS Security Group controls port access

---

## Maintenance Contacts

For server issues requiring AWS console access or root-level changes, contact the system administrator.

---

## Related Documentation

| File | Description |
|------|-------------|
| `README.md` | Quick reference and entry point |
| `AEI_DATABASE_SCHEMA.md` | Complete database schema with tables and relationships |
