# AEI Scheduler Remote Server

## Project Location: `/var/opt/AEI_REMOTE/`

This directory contains documentation and access tools for the AEI Scheduler production server hosted on AWS.

---

## Servers

### Remote Server (AWS): 18.225.0.90

```bash
# Convert PPK key to OpenSSH format (one-time)
puttygen CONNECTORS/SSH/schedular_server_private_key.ppk -O private-openssh -o /tmp/aei_key
chmod 600 /tmp/aei_key

# Connect to server
ssh -i /tmp/aei_key Julian@18.225.0.90
```

| Application | URL |
|-------------|-----|
| **Scheduler** | https://aeihawaii.com/scheduler/ |
| **Admin** | https://aeihawaii.com/scheduler/admin.php |
| **Photo API** | https://aeihawaii.com/photoapi/ |
| **Support** | https://aeihawaii.com/support/ |

### Local Server: 72.235.242.139

| Resource | URL/Path |
|----------|----------|
| **Domain** | https://upload.aeihawaii.com |
| **Upload Endpoint** | /upload/uploadlocallat_kuldeep.php |
| **Photo Storage** | /mnt/dropbox/2025 Customers/ |

### Integration

The remote server syncs photos to the local server via curl POST to:
- `https://upload.aeihawaii.com/uploadlocallat_kuldeep.php`
- or `http://72.235.242.139/upload/uploadlocallat_kuldeep.php`

---

## This Project Contains

| File/Directory | Purpose |
|----------------|---------|
| `README.md` | Quick reference, connection info, download commands |
| `REMOTE_SERVER.md` | Complete server documentation and troubleshooting |
| `AEI_DATABASE_SCHEMA.md` | Database tables, relationships, common queries |
| `CONNECTORS/SSH/` | SSH private key for remote access |
| `CONNECTORS/EMAIL/` | Email service credentials and documentation |
| `PHOTO_API_BACKUP/` | Photo API backup + integration documentation |
| `WORK/` | Maintenance procedures documentation |

---

## Remote Server Directory Structure

```
/var/www/vhosts/aeihawaii.com/httpdocs/
├── scheduler/          # Main Scheduler Application (CodeIgniter)
├── support/            # osTicket Support System
├── esign/              # E-signature system
├── crm/                # CRM module
├── hrm/                # HR management
└── files/              # Uploaded files
```

---

## Database Access

```bash
# Remote connection
mysql -h 18.225.0.90 -u AEI_User -p'P@55w02d7777' mandhdesign_schedular
```

| Parameter | Value |
|-----------|-------|
| Host | 18.225.0.90 |
| Database | mandhdesign_schedular |
| User | AEI_User |
| Password | P@55w02d7777 |
