# AEI Remote — Scheduler Management Hub

Management hub for the AEI Hawaii Scheduler production system. Provides
documentation, deployment tools, and connection infrastructure for maintaining
the scheduler web application.

**Start here:** Read [`CLAUDE.md`](CLAUDE.md) for a quick orientation.

---

## Quick Start

```bash
# Connect to remote server
scripts/ssh_connect.sh

# Deploy a file to local test site
scripts/deploy_local.sh system/application/controllers/your_file.php

# Deploy a file to production
scripts/deploy_remote.sh system/application/controllers/your_file.php

# Sync latest code from remote
scripts/sync_from_remote.sh --dry-run
```

---

## Project Structure

| Directory | Description |
|-----------|-------------|
| [`SCHEDULER_DOCS/`](SCHEDULER_DOCS/README.md) | Symlink → `/var/www/html/dev_scheduler/DOCS/` — canonical scheduler docs (99+ files) |
| [`PROJECT_DOCS/`](PROJECT_DOCS/) | Deployment, testing, architecture, and workflow guides |
| [`CONNECTORS/`](CONNECTORS/) | SSH keys, database credentials, email credentials |
| [`scripts/`](scripts/README.md) | Deployment and sync helper scripts |
| [`AEI_PHOTO_API_PROJECT/`](AEI_PHOTO_API_PROJECT/) | Photo upload system enhancement project |
| [`WORK/`](WORK/README.md) | Maintenance items (MAINT-001 through MAINT-011) |
| [`LOCAL_SYNC/`](LOCAL_SYNC/README.md) | Detailed remote-to-local sync procedures |

## Key Reference Files

| File | Description |
|------|-------------|
| [`CLAUDE.md`](CLAUDE.md) | Agent instruction file — paths, credentials, rules |
| [`REMOTE_SERVER.md`](REMOTE_SERVER.md) | Remote server architecture and troubleshooting |
| [`AEI_DATABASE_SCHEMA.md`](AEI_DATABASE_SCHEMA.md) | Database schema reference |
| [`RELATED_PROJECTS.md`](RELATED_PROJECTS.md) | Other related projects |

---

## Environments

| Environment | URL | Path |
|-------------|-----|------|
| **Local dev** | `http://aeihawaii.com/scheduler/` | `/var/www/html/dev_scheduler/SCHEDULER/` |
| **Remote production** | `https://aeihawaii.com/dev/scheduler/` | `/var/www/vhosts/aeihawaii.com/httpdocs/dev/scheduler/` |
| **Backup mirror** | — | `/mnt/e/remote_scheduler_backup/source/` |

## Documentation Guide

- **Working on the scheduler code?** Start with [`SCHEDULER_DOCS/README.md`](SCHEDULER_DOCS/README.md)
- **Deploying changes?** Read [`PROJECT_DOCS/DEPLOYMENT_GUIDE.md`](PROJECT_DOCS/DEPLOYMENT_GUIDE.md)
- **Testing locally?** Read [`PROJECT_DOCS/TESTING_GUIDE.md`](PROJECT_DOCS/TESTING_GUIDE.md)
- **Starting a new project?** Read [`PROJECT_DOCS/ENHANCEMENT_WORKFLOW.md`](PROJECT_DOCS/ENHANCEMENT_WORKFLOW.md)
- **Need a quick cheat sheet?** Read [`PROJECT_DOCS/QUICK_REFERENCE.md`](PROJECT_DOCS/QUICK_REFERENCE.md)
