# Testing Guide

How to test changes on the local development environment before deploying to
production.

---

## Local Test Environment

| Item | Value |
|------|-------|
| **URL** | `http://aeihawaii.com/scheduler/` |
| **Admin** | `http://aeihawaii.com/scheduler/admin` |
| **Path** | `/var/www/html/dev_scheduler/SCHEDULER/` |
| **Database** | `mysql -u root -pscheduler mandhdesign_schedular` |
| **PHP** | 5.6 via FPM (production uses 7.3.30) |
| **Test User** | `austin@alternateenergyhawaii.com` / `password` |
| **Error log** | `/var/log/apache2/dev_scheduler_error.log` |

---

## Quick Test Checklist

For small changes (single function fix, CSS tweak):

- [ ] Page loads without errors
- [ ] Changed functionality works as expected
- [ ] No PHP errors in Apache error log
- [ ] No JavaScript errors in browser console
- [ ] Other functionality on the same page still works

---

## Thorough Test Checklist

For significant changes (controller modifications, database queries, multi-file changes):

### Functional Testing
- [ ] Target functionality works correctly
- [ ] Edge cases handled (empty data, large datasets, special characters)
- [ ] All related pages still load
- [ ] Form submissions work
- [ ] AJAX calls return expected data (check Network tab)

### Database Testing
- [ ] Queries return expected results
- [ ] No unintended data modifications
- [ ] Verify with: `mysql -u root -pscheduler mandhdesign_schedular -e "YOUR QUERY"`

### Error Monitoring
```bash
# Watch Apache errors in real-time
tail -f /var/log/apache2/error.log

# Check CodeIgniter logs
ls -la /var/www/html/dev_scheduler/SCHEDULER/system/logs/
```

### Cross-Page Testing
If you modified a controller, test all pages that use it:
1. Look up routes in `SCHEDULER_DOCS/11-AI_CONTEXT_MAP/ACTIVE_ROUTES.csv`
2. Test each route that maps to the modified controller

### PHP Compatibility Check
Production runs PHP 7.3.30 (upgraded from 5.3.29 on 2026-02-23). Watch for:
- No typed properties (PHP 7.4+)
- No arrow functions `fn()` (PHP 7.4+)
- No null coalescing assignment `??=` (PHP 7.4+)
- No union types (PHP 8.0+)
- No named arguments (PHP 8.0+)

```bash
# Quick syntax check (won't catch all 5.3 issues but catches obvious ones)
php -l /var/www/html/dev_scheduler/SCHEDULER/path/to/file.php
```

---

## Comparing with Remote

### File comparison
```bash
# Compare a specific file
ssh -i /tmp/aei_key Julian@18.225.0.90 \
  "cat /var/www/vhosts/aeihawaii.com/httpdocs/dev/scheduler/path/to/file.php" \
  | diff - /var/www/html/dev_scheduler/SCHEDULER/path/to/file.php
```

### Checksum comparison
```bash
scripts/verify_deployment.sh local path/to/file.php
scripts/verify_deployment.sh remote path/to/file.php
```

### Database comparison
```bash
# Local table count
mysql -u root -pscheduler -e \
  "SELECT COUNT(*) FROM information_schema.tables WHERE table_schema='mandhdesign_schedular';"

# Remote table count
mysql -h 18.225.0.90 -u AEI_User -p'P@55w02d7777' -e \
  "SELECT COUNT(*) FROM information_schema.tables WHERE table_schema='mandhdesign_schedular';"
```

---

## Common Test Scenarios

### Testing Proposal Changes
1. Navigate to a customer record
2. Create or edit a proposal
3. Verify calculations are correct
4. Test PDF generation
5. Test e-signature flow

### Testing Calendar/Schedule Changes
1. Open the job calendar
2. Verify jobs display correctly
3. Test drag-and-drop (if applicable)
4. Check different date ranges

### Testing Admin Features
1. Login as admin at `/scheduler/admin`
2. Test affected admin pages
3. Verify user permissions work correctly
4. Check reports generate properly

---

## When Testing Is Complete

1. Note any issues found and fix them
2. Re-test after fixes
3. Proceed to deployment: `scripts/deploy_remote.sh path/to/file.php`
4. Verify on production: `scripts/verify_deployment.sh remote path/to/file.php`
