# Quick Reference

One-page cheat sheet for the AEI Scheduler project.

---

## SSH Connection

```bash
# Using script (recommended)
scripts/ssh_connect.sh

# Manual
puttygen CONNECTORS/SSH/schedular_server_private_key.ppk -O private-openssh -o /tmp/aei_key
chmod 600 /tmp/aei_key
ssh -i /tmp/aei_key Julian@18.225.0.90
```

---

## Key Paths

| Location | Path |
|----------|------|
| **This project** | `/var/www/html/AEI_REMOTE/` |
| **Local dev site** | `/var/www/html/dev_scheduler/SCHEDULER/` |
| **Local URL** | `http://aeihawaii.com/scheduler/` |
| **Remote production** | `/var/www/vhosts/aeihawaii.com/httpdocs/dev/scheduler/` |
| **Remote URL** | `https://aeihawaii.com/dev/scheduler/` |
| **Backup mirror** | `/mnt/e/remote_scheduler_backup/source/` |
| **DB backups** | `/mnt/e/remote_scheduler_backup/database/` |

---

## Database

```bash
# Local
mysql -u root -pscheduler mandhdesign_schedular

# Remote
mysql -h 18.225.0.90 -u AEI_User -p'P@55w02d7777' mandhdesign_schedular
```

---

## Common Commands

```bash
# Deploy to local test site
scripts/deploy_local.sh system/application/controllers/your_file.php

# Deploy to production
scripts/deploy_remote.sh system/application/controllers/your_file.php

# Verify deployment
scripts/verify_deployment.sh local system/application/controllers/your_file.php
scripts/verify_deployment.sh remote system/application/controllers/your_file.php

# Sync from remote to local
scripts/sync_from_remote.sh --dry-run
scripts/sync_from_remote.sh

# Check remote error logs
ssh -i /tmp/aei_key Julian@18.225.0.90 "tail -50 /var/log/httpd/error_log"

# Remote file ownership fix
ssh -i /tmp/aei_key Julian@18.225.0.90 "sudo chown -R ec2-user:ec2-user /path/"
```

---

## Critical Rules

1. **NEVER** overwrite `database.php` or `config.php` on local dev
2. **ALWAYS** `sudo chown ec2-user:ec2-user` after uploading to remote
3. **ALWAYS** create remote backups before deploying
4. Code must work on **PHP 7.3.30** (no typed properties, no arrow functions, no `??=`)

---

## Find Things in the Scheduler

| Need | Where to Look |
|------|---------------|
| Controller for a URL | `SCHEDULER_DOCS/11-AI_CONTEXT_MAP/ACTIVE_ROUTES.csv` |
| Controller by feature | `SCHEDULER_DOCS/11-AI_CONTEXT_MAP/CONTROLLER_INDEX.json` |
| Database tables | `SCHEDULER_DOCS/02-DATABASE/SCHEMA_OVERVIEW.md` |
| Known bugs | `SCHEDULER_DOCS/09-ISSUES_AND_DEBT/KNOWN_BUGS.md` |
| Domain terminology | `SCHEDULER_DOCS/11-AI_CONTEXT_MAP/DOMAIN_GLOSSARY.md` |

---

## Server Info

| Component | Remote | Local |
|-----------|--------|-------|
| **IP** | 18.225.0.90 | localhost |
| **PHP** | 7.3.30 | 8.2 |
| **MySQL** | 5.5.62 (mysqli) | MariaDB |
| **Web Server** | Apache 2.4.61 (httpd24) | Apache2 |
| **OS** | Amazon Linux 2018.03 | WSL2 (Ubuntu) |
