# Enhancement Methodology

> Canonical process for all AEI enhancement work. Supersedes `ENHANCEMENT_WORKFLOW_v1.md`.

---

## Decision Tree: Where Does My Enhancement Go?

```
Is it about the photo upload/sync pipeline (upload.php, photos API,
  WebP, Dropbox sync, mobile photo listing, fetch_image)?
  YES → Photo API area
  NO  → Scheduler Core area (everything else)
```

---

## Routing Table

| Area | Path | Tracker File | ID Range | Next ID | Conventions |
|------|------|-------------|----------|---------|-------------|
| **Scheduler Core** | `dev_scheduler/ENHANCEMENTS/` | `TRACKER.md` | ENH-001 – ENH-021 | ENH-022 | `ENH-NNN_short_name/` with `original/`, `modified/`, `PLAN.md` |
| **Photo API** | `AEI_REMOTE/AEI_PHOTO_API_PROJECT/ENHANCEMENTS/` | `ENHANCEMENT_LOG.md` | ENH-000 – ENH-020 | ENH-021 | `ENH-NNN_NAME/` with `ORIGINAL/`, `NEW/`, `README.md`, `CHANGES.md` |

> **ID sequences are independent.** Each area has its own numbering. Do not attempt to merge or deduplicate across areas.

---

## PHP Version Matrix

| Environment | PHP Version | Key Restrictions |
|-------------|-------------|-----------------|
| Local dev (`dev_scheduler/SCHEDULER/`) | 5.6 via FPM | No PHP 7+ features, `mysql_*` functions in use |
| Remote production (18.225.0.90) | **7.3.30** | Apache 2.4.61, mod_php7, mysqli driver (upgraded from 5.3.29 on 2026-02-23) |

All code must be compatible with **PHP 7.3.30** before deploying to production. No PHP 7.4+ features (typed properties, arrow functions, null coalescing assignment).

---

## Area-Specific Conventions

### Scheduler Core (`dev_scheduler/ENHANCEMENTS/`)

```
ENH-NNN_short_name/
├── PLAN.md            # Problem, analysis, solution, changes, verification, rollback
├── original/          # Exact copies of files BEFORE modification (lowercase)
└── modified/          # Copies of files AFTER modification (lowercase)
```

- **Tracker format:** Checkbox status — `[x]` Complete, `[~]` In Progress, `[ ]` Planned, `[!]` Blocked
- **Naming:** lowercase with underscores (e.g., `ENH-014_myjobs_batch_prefetch`)
- **Backup dirs:** lowercase (`original/`, `modified/`)
- **Required doc:** `PLAN.md` (problem, analysis, solution, changes, verification, rollback)
- **Scope:** Scheduler performance, query optimization, UI fixes, cross-cutting features, bug fixes

### Photo API (`AEI_REMOTE/AEI_PHOTO_API_PROJECT/ENHANCEMENTS/`)

```
ENH-NNN_NAME/
├── README.md          # Problem statement, solution, status, files affected, testing
├── CHANGES.md         # Detailed change log per file
├── ORIGINAL/          # Backup of original files (uppercase)
└── NEW/               # Modified/new files ready for deployment (uppercase)
```

- **Tracker format:** Table with Status column (Reference, Deployed, Implemented, Proposed, Planning, Planned, etc.)
- **Naming:** UPPERCASE descriptive (e.g., `ENH-009_UNIFIED_STORAGE`)
- **Backup dirs:** uppercase (`ORIGINAL/`, `NEW/`)
- **Required docs:** `README.md` + `CHANGES.md`
- **Future items:** `FUTURE/ENH-FXX_NAME/` for unscheduled work
- **Scope:** Photo upload, sync, WebP conversion, mobile photo listing, Dropbox integration

---

## Enhancement Lifecycle

```
PLANNING  →  LOCAL_DEV  →  TESTING  →  DEPLOYED  →  VERIFIED
                                            │
                                            └──→  REVERTED (if issues)
```

| Phase | Description |
|-------|-------------|
| **PLANNING** | Problem identified, analyzing solution approach |
| **LOCAL_DEV** | Changes being developed and tested locally |
| **TESTING** | Changes complete, undergoing local testing |
| **DEPLOYED** | Changes pushed to production |
| **VERIFIED** | Production verified working correctly |
| **REVERTED** | Changes rolled back due to issues |
| **ON_HOLD** | Paused, waiting for decision or dependency |

---

## Step-by-Step Checklist

### 1. Determine the correct area
Use the decision tree above. Check the routing table for the next available ID.

### 2. Create the enhancement directory

```bash
# Scheduler Core
mkdir -p dev_scheduler/ENHANCEMENTS/ENH-NNN_short_name/{original,modified}

# Photo API
mkdir -p AEI_REMOTE/AEI_PHOTO_API_PROJECT/ENHANCEMENTS/ENH-NNN_NAME/{ORIGINAL,NEW}
```

### 3. Backup original files BEFORE making any changes
Copy every file you plan to modify into the backup directory (`original/` or `ORIGINAL/`).

### 4. Write the required documentation
- Scheduler Core: Create `PLAN.md` with problem, analysis, solution, changes, verification, rollback
- Photo API: Create `README.md` with problem, solution, status, files affected, testing

### 5. Develop and test locally
- Work in the local dev environment (`dev_scheduler/SCHEDULER/`)
- Test at `http://dev.aeihawaii.com/scheduler/`
- Login: `austin@alternateenergyhawaii.com` / `password`

### 6. Copy modified files to the enhancement directory
After changes work locally, copy to `modified/` or `NEW/`.

### 7. Update the tracker
- Scheduler Core: Update `ENHANCEMENTS/TRACKER.md` with checkbox entry
- Photo API: Update `ENHANCEMENT_LOG.md` summary table + dependency graph

### 8. Update CLAUDE.md
- Scheduler Core: Update the enhancements table in `dev_scheduler/CLAUDE.md`
- Photo API: Update directory guide in `AEI_REMOTE/CLAUDE.md` if needed

### 9. Deploy to production
Follow `AEI_REMOTE/PROJECT_DOCS/DEPLOYMENT_GUIDE.md` or use `scripts/aei_deploy.sh`.

### 10. Verify and update status
Update tracker status from TESTING → DEPLOYED → VERIFIED after production verification.

---

## Cross-References

| Document | Location | Purpose |
|----------|----------|---------|
| Scheduler CLAUDE.md | `dev_scheduler/CLAUDE.md` | Auto-loaded context for scheduler work |
| Remote CLAUDE.md | `AEI_REMOTE/CLAUDE.md` | Auto-loaded context for remote/photo work |
| Deployment Guide | `AEI_REMOTE/PROJECT_DOCS/DEPLOYMENT_GUIDE.md` | How to deploy changes |
| Testing Guide | `AEI_REMOTE/PROJECT_DOCS/TESTING_GUIDE.md` | How to test changes |
| Scheduler Tracker | `dev_scheduler/ENHANCEMENTS/TRACKER.md` | Scheduler enhancement status |
| Photo API Tracker | `AEI_REMOTE/AEI_PHOTO_API_PROJECT/ENHANCEMENTS/ENHANCEMENT_LOG.md` | Photo system enhancement status |
| N+1 Query Audit | `dev_scheduler/ENHANCEMENTS/N1_QUERY_AUDIT.md` | Planned scheduler optimizations |
| Archived workflow | `AEI_REMOTE/PROJECT_DOCS/ENHANCEMENT_WORKFLOW_v1.md` | Original workflow doc (superseded) |
