# Project Architecture

## Overview

This project (`AEI_REMOTE`) is a management hub for the AEI Hawaii Scheduler, a legacy
CodeIgniter web application running on AWS. The hub provides documentation, connection
tools, deployment scripts, and maintenance tracking.

The actual scheduler code lives in separate locations. This project does NOT contain
the scheduler source code itself.

---

## Three Environments

```
┌──────────────────────────┐
│   REMOTE PRODUCTION      │
│   18.225.0.90            │
│   /httpdocs/dev/scheduler│
│   PHP 7.3.30 / MySQL 5.5│
└──────────┬───────────────┘
           │ rsync (pull only)
           v
┌──────────────────────────┐
│   BACKUP MIRROR          │
│   /mnt/e/remote_         │
│   scheduler_backup/      │
│   source/                │
└──────────┬───────────────┘
           │ rsync (excludes configs)
           v
┌──────────────────────────┐
│   LOCAL DEVELOPMENT      │
│   /var/www/html/         │
│   dev_scheduler/SCHEDULER│
│   PHP 8.2 / MariaDB     │
│   http://aeihawaii.com/  │
│   scheduler/ (via hosts) │
└──────────────────────────┘
```

**Data flows one way:** Remote -> Backup Mirror -> Local Dev.
Deployments go the other way: Local Dev -> Remote (via SCP).

---

## Directory Map

```
/var/www/html/AEI_REMOTE/
│
├── CLAUDE.md                    # Agent instructions (start here)
├── README.md                    # Project overview
│
├── SCHEDULER_DOCS/              # 99 docs about the scheduler codebase
│   ├── README.md                # Navigation guide for the 99 docs
│   ├── 00-ENVIRONMENT_AND_OPS/  # Server setup, dependencies, permissions
│   ├── 01-ARCHITECTURE/         # CodeIgniter structure, routing, auth
│   ├── 02-DATABASE/             # All 453 tables, relationships, data hygiene
│   ├── 03-EQUIPMENT_TYPES/      # PV, AC, SWH, SAF, Roof, EV, GC, Storage
│   ├── 04-WORKFLOWS/            # Sales, proposals, scheduling, eSign
│   ├── 05-CONTROLLERS/          # All controllers (tiered deep dives)
│   ├── 06-VIEWS_AND_UI/         # Views, templates, JS/CSS, AJAX
│   ├── 07-INTEGRATIONS/         # osTicket, Tracmor, AWS, PVWatts
│   ├── 08-ADMIN_FEATURES/       # Users, permissions, reports, cron
│   ├── 09-ISSUES_AND_DEBT/      # Bugs, security, dead code, performance
│   ├── 10-REFACTOR_READINESS/   # Assessment, modernization path
│   └── 11-AI_CONTEXT_MAP/       # Machine-readable JSON/CSV indexes
│
├── PROJECT_DOCS/                # Deployment, testing, workflow guides
│   ├── ARCHITECTURE.md          # This file
│   ├── DEPLOYMENT_GUIDE.md      # Step-by-step deployment process
│   ├── TESTING_GUIDE.md         # Local testing procedures
│   ├── ENHANCEMENT_WORKFLOW.md  # How to structure new projects
│   └── QUICK_REFERENCE.md       # One-page cheat sheet
│
├── CONNECTORS/                  # Connection infrastructure
│   ├── SSH/                     # PPK key for remote server
│   ├── DATABASE/                # Connection strings (local & remote)
│   └── EMAIL/                   # SMTP/IMAP credentials, email system docs
│
├── scripts/                     # Deployment and sync helper scripts
│   ├── ssh_connect.sh           # Convert PPK + open SSH session
│   ├── deploy_local.sh          # Deploy to local test site
│   ├── deploy_remote.sh         # Deploy to production
│   ├── verify_deployment.sh     # Post-deployment verification
│   └── sync_from_remote.sh      # Pull latest from remote
│
├── AEI_PHOTO_API_PROJECT/       # Photo upload system project
├── WORK/                        # Maintenance items (MAINT-001 to MAINT-011)
├── LOCAL_SYNC/                  # Detailed remote-to-local sync procedures
├── AEI_DATABASE_SCHEMA.md       # High-level database schema reference
├── REMOTE_SERVER.md             # Remote server architecture and troubleshooting
├── RELATED_PROJECTS.md          # Other related projects
└── _backups/                    # Symlink to /mnt/e/remote_scheduler_backup/
```

---

## The Scheduler Application

| Property | Value |
|----------|-------|
| **Framework** | CodeIgniter 1.7.x/2.x |
| **Language** | PHP 7.3.30 (production, upgraded 2026-02-23) |
| **Database** | MySQL 5.5 (mysqli driver) / MariaDB (local) |
| **Tables** | 453 |
| **Controllers** | 270+ active |
| **Frontend** | jQuery 1.x, jQuery UI, inline scripts |
| **Equipment Types** | PV, AC, SWH, SAF, Roof, EV, GC, Storage |

### Source Code Layout (on both local and remote)

```
scheduler/
├── index.php                          # Main entry point
├── admin.php                          # Admin interface
├── ajax.php                           # AJAX handlers
├── login.php                          # Authentication
├── system/application/
│   ├── controllers/                   # PHP controllers (main logic)
│   ├── models/                        # Database models
│   ├── views/                         # Template views
│   ├── config/
│   │   ├── database.php               # DB credentials (DIFFERS local vs remote)
│   │   └── config.php                 # Base URL (DIFFERS local vs remote)
│   └── libraries/                     # Custom libraries
├── assets/                            # CSS, JS, images
└── MPDF531/                           # PDF generation library
```

---

## Key Relationships

- **SCHEDULER_DOCS/** documents what the scheduler code does (read-only reference)
- **PROJECT_DOCS/** documents how to work with the scheduler (processes)
- **scripts/** automate the processes described in PROJECT_DOCS/
- **CONNECTORS/** hold the credentials scripts need
- **WORK/** tracks specific maintenance items being worked on
- **AEI_PHOTO_API_PROJECT/** is a standalone enhancement project (reference template)
