# Honolulu DPP Salesforce Portal - API Investigation

**Site:** https://honolulu.my.site.com/s/
**Platform:** Salesforce Experience Cloud (formerly Community Cloud)
**Organization:** City & County of Honolulu, Department of Planning and Permitting
**Org ID:** 00Da5000001ExEAEA0
**Managed Package:** MUSW (Municipal Software)
**Investigation Date:** 2026-02-23

## Quick Reference

### Production Account (for sync)

| Item | Value |
|------|-------|
| Portal URL | `https://honolulu.my.site.com/s/` |
| Login | `permits@aeihawaii.com` / `p455word` |
| User ID | `005cx000005lrh7AAA` |
| User Type | `CSP_LITE_PORTAL` (Customer Community Plus Lite) |
| Account Name | ALTERNATE ENERGY INC |
| Shared Permits | **413** (including 2026 permits) |

### Original Investigation Account

| Item | Value |
|------|-------|
| Login | `kahumana@gmail.com` / `Sun888Power` |
| User ID | `005cx00000Bh8C5AAJ` |
| User Name | JULIAN KAHUMANA |
| Shared Permits | 1 (BP-2025-189630) |

## Current Status

**All Salesforce APIs are blocked** for both accounts (`API_DISABLED_FOR_ORG`).
The only viable approach is **Playwright headless browser automation** -- logging in
via browser, navigating portal pages, and extracting data from rendered HTML.

See `API_TEST_RESULTS.md` for the full testing evidence.
See `IMPLEMENTATION_ROADMAP.md` for the cron-based Playwright sync plan.

## Files in This Directory

### Investigation & API Docs
| File | Description |
|------|-------------|
| `README.md` | This file - overview and summary |
| `API_ACCESS.md` | API access matrix - what works, what's blocked, endpoint docs |
| `OBJECT_MODEL.md` | Salesforce object model, fields, relationships, portal navigation |
| `AUTHENTICATION.md` | Auth methods, OAuth config, session handling, programmatic access |
| `API_TEST_RESULTS.md` | **permits@aeihawaii.com testing results** (2026-02-23) - 16 tests run |

### Integration Planning
| File | Description |
|------|-------------|
| `CURRENT_AEI_PERMIT_SYSTEM.md` | Audit of AEI's existing permit tracking (tables, controllers, broken scraper) |
| `FIELD_MAPPING.md` | Field-by-field mapping: Salesforce -> AEI scheduler |
| `PERMIT_TRACKING_PLAN.md` | Original integration plan: schema, sync script, cron, UI, priorities |
| `IMPLEMENTATION_ROADMAP.md` | **Playwright-based sync plan** - cron schedule, phases, code approach |

### Raw Data
| File | Description |
|------|-------------|
| `salesforce_object_metadata.json` | Complete metadata for all 6 accessible SF objects (204 KB) |
| `salesforce_all_fields.txt` | Human-readable field listing across all objects (130 KB) |

## The Big Picture

```
BEFORE (broken):  AEI scrapes DPP ASP.NET site → HTML parsing → fails silently (since 2022)
ORIGINAL PLAN:    AEI calls DPP Salesforce UI API → structured JSON → permit_sync tables
ACTUAL PLAN:      Playwright browser login → navigate portal pages → parse rendered HTML → permit_sync tables
```

**Old DPP scraper** broke in 2022 when DPP migrated from ASP.NET to Salesforce.
No valid permit status data has been collected in 3+ years.

**API access is blocked** -- the `permits@aeihawaii.com` Community Portal account does
not have API privileges (`API_DISABLED_FOR_ORG`). This cannot be fixed without DPP
enabling the "API Enabled" permission on the portal profile.

**Playwright headless browser** is the proven alternative. Browser login works,
portal pages render all 413+ shared permits with full detail (phase, status, dates,
fees, CO status). A Python cron job will automate this on the local WSL2 machine.

## Portal Navigation

| Page | URL |
|------|-----|
| Home | `/s/` |
| My Projects | `/s/my-projects` |
| My Permits | `/s/my-permits` (tabs: My Permits / Shared Permits) |
| My Licenses | `/s/my-licenses` |
| Planning | `/s/my-applications` |
| Approvals | `/s/my-approvals` |
| RFIs | `/s/my-rfis` |
| Permit Detail | `/s/permit2/{sf_record_id}/{slug}` |
