# DPP Salesforce - Object Model

## Managed Package: MUSW (Municipal Software)

All custom objects use the `MUSW__` namespace prefix. This is a government
permitting managed package.

## Object Access Matrix

| Object API Name | Label | Fields | Accessible | Notes |
|----------------|-------|--------|------------|-------|
| `MUSW__Permit2__c` | Permit | 529 | YES | Primary object - building/site/zoning/coastal permits |
| `MUSW__Inspection__c` | Inspection | 94 | YES | Permit inspections |
| `MUSW__Fee__c` | Fee | 61 | YES | Permit fees and payments |
| `MUSW__Review__c` | Review | 51 | YES | Plan review records |
| `MUSW__Parcel__c` | Parcel | 169 | YES | TMK parcel records |
| `MUSW__Address__c` | Address | 55 | YES | Address records |
| `Account` | Account | 138 | YES | Standard Salesforce Account |
| `Contact` | Contact | 69 | YES | Standard Salesforce Contact |
| `MUSW__Project__c` | Project | - | NO (403) | Projects container for permits |
| `MUSW__Task__c` | Task | - | NO (403) | Workflow tasks |
| `MUSW__Document__c` | Document | - | NO (403) | Uploaded documents |
| `MUSW__License__c` | License | - | NO (403) | License records |
| `Case` | Case | - | NO (403) | Standard Case object |

## MUSW__Permit2__c (Permit) - Key Fields

### Record Type
- **Record Type ID:** `012a5000000Djp2AAC`
- **Record Type Name:** Building Permit

### All 38 Fields Exposed via UI API Record

| Field API Name | Sample Value | Description |
|---------------|-------------|-------------|
| `Name` | BP-2025-189630 | Permit number |
| `MUSW__Description__c` | (Building Permit) [TMK: 39008016]... | Full job description |
| `MUSW__Phase__c` | Review | Current phase (Review, etc.) |
| `MUSW__Status__c` | In Progress | Current status |
| `MUSW__Type2__c` | Building | Permit type (Building, Site Dev, Zoning, Coastal) |
| `MUSW__Use_Class__c` | Residential | Use class |
| `MUSW__Use_Type__c` | Single-Unit Dwelling | Use type |
| `MUSW__Work_Type2__c` | Repair | Work type |
| `MUSW__Valuation__c` | $800.00 | Project valuation |
| `MUSW__Account__c` | 001cx00000KPYFuAAP | Account ID (lookup) |
| `MUSW__Account__r` | JULIAN V KAHUMANA | Account name (display) |
| `MUSW__Applicant__c` | 003cx00000KdO6fAAF | Contact ID (lookup) |
| `MUSW__Applicant__r` | JULIAN V KAHUMANA | Applicant name (display) |
| `MUSW__Address__c` | a04a500005IHSlcAAH | Address record ID |
| `MUSW__Address__r` | 520 LUNALILO HOME RD Honolulu / Hawaii Kai, HI 96825 | Address (display) |
| `MUSW__Project2__c` | a1Lcx000001uH41EAE | Project ID (lookup) |
| `MUSW__Project2__r` | Ballini Meter Pull Box Replacement | Project name (display) |
| `MUSW__Total_Fees__c` | $5.60 | Total fees assessed |
| `MUSW__Total_Payments__c` | $5.60 | Total payments made |
| `MUSW__Total_Balance__c` | $0.00 | Outstanding balance |
| `MUSW__Issue_Date__c` | (null) | Permit issue date |
| `MUSW__DateCompleted__c` | (null) | Completion date |
| `MUSW__Expiration_Date__c` | (null) | Permit expiration |
| `Application_Accepted_Date__c` | 2/20/2026 | Application accepted |
| `Application_Expiration_Date__c` | 2/20/2027 | Application expires |
| `CO_Required__c` | No | Certificate of Occupancy required |
| `Final_CO_Issued__c` | false | CO issued flag |
| `Electrical_Phases__c` | 2 | Number of electrical phases |
| `Plumbing_Phases__c` | (null) | Number of plumbing phases |
| `NPDES_Permit_No__c` | (null) | NPDES number |
| `Plan_Review_Milestone_Completed__c` | --None-- | Plan review milestone |
| `Sub_Type_Multi_Select__c` | Other | Sub-type multi-select |
| `Application__c` | (null) | Application lookup |
| `Legacy_Address__c` | (null) | Legacy address text |
| `Job_Description_MM__c` | (null) | Model Homes description |
| `M_M_Approval_No__c` | (null) | M&M Approval number |

### Full Object Metadata (529 Fields)

The `object-info` endpoint reveals 529 fields on the Permit object. The first
20 alphabetically include:

- `A_C_Rated_Capacity_Btu_hr__c`
- `A_temporary_struct_erected_Lessthanseven__c`
- `A_temporary_struct_erected_oversevendays__c`
- `A_temporary_structure_will_be_erected__c`
- `Acceptance_Date__c`
- `Acceptance_Signed_by__c`
- `Accepted_Value__c`
- `Account__c`
- `Acre__c` / `Acres__c`
- `Addition_Type__c`
- `Additional_Location_Information__c`
- `Additional_Owner_Information__c`
- `Affordable_Floor_Area__c`
- `Age_of_Building__c`
- `Agriculture__c`
- `AllContractorsApproved__c`
- `Applicant__c`
- `Application_Accepted_Date__c`
- `Application_Expiration_Date__c`

These cover building details, zoning, renewable energy fields, contractor
info, inspection scheduling, fees, and much more.

## Salesforce Record ID Prefixes

| Prefix | Object |
|--------|--------|
| `a1B` | MUSW__Permit2__c (Permit) |
| `a1L` | MUSW__Project__c (Project) |
| `a04` | MUSW__Address__c (Address) |
| `001` | Account |
| `003` | Contact |
| `005` | User |
| `012` | RecordType |

## Portal Navigation Structure

| Page | URL Path | Description |
|------|----------|-------------|
| Home | `/s/` | Landing page with permit type links |
| My Projects | `/s/my-projects` | User's projects |
| My Permits | `/s/my-permits` | User's permits (My Permits + Shared Permits tabs) |
| My Licenses | `/s/my-licenses` | User's licenses |
| Planning | `/s/my-applications` | Planning applications |
| Approvals | `/s/my-approvals` | Approval requests |
| RFIs | `/s/my-rfis` | Requests for Investigation |
| Public Input | `/s/public-comment` | Public comment submissions |
| Paused Items | `/s/my-paused-applications` | Incomplete applications |
| New Building Permit | `/s/new-permit-application` | Start new building permit |
| New Site Dev Permit | `/s/new-site-dev-permit` | Start new site dev permit |
| New Zoning Permit | `/s/new-zoning-permit` | Start new zoning permit |
| New Coastal Permit | `/s/new-coastal-permit` | Start new coastal permit |
| New Planning App | `/s/planning-applications` | Start new planning app |
| License Application | `/s/new-license-application` | New license |
| New RFI/Complaint | `/s/new-rfi-application` | File complaint |
| New Approval App | `/s/new-approval` | New approval application |
| Shared Record Detail | `/s/shared-record-detail?recordId={id}&ObjectType={type}` | View shared record |

## Permit Workflow Tasks (Observed)

For permit BP-2025-189630, the following tasks were visible:

| Task | Status | Created | Due | Completed |
|------|--------|---------|-----|-----------|
| Applicant Upload Task | Complete | 9/29/2025 | 10/02/2025 | 10/09/2025 |
| Prescreen Review Task | Complete | 10/09/2025 | 10/23/2025 | 11/17/2025 |
| Initial Payment Verification | Complete | 11/17/2025 | 11/18/2025 | 11/17/2025 |
| Initial Fees Due | Pending | 11/17/2025 | - | - |

## Console Log Intelligence

The permit detail page logs reveal internal state:

- `profileName`: "City of Honolulu Customer Community Lite User"
- `isCommunityUser`: true
- `paymentFormSiteURL`: `https://honolulu.my.site.com/...` (payment integration)
- `objectType`: `MUSW__Permit2__c`
- `recordTypeName`: "Building Permit"
- `createdDate permit`: 2025-09-29T18:58:35.000Z
- `totalFee`: 0
- `ownerConsent`: true
- `checkContractorConsent`: "Approved"
- `isPlanReview`: false
- `isInitialReviewCompleted`: undefined
